/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.cache.model;

import com.atlassian.plugin.servlet.cache.model.CacheableResponse;
import com.atlassian.plugin.servlet.cache.model.ETagToken;
import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class CacheInformation {
    @VisibleForTesting
    static final long EMPTY_MODIFIED_SINCE_HEADER = -1L;
    private final long ifModifiedSinceHeader;
    private final String ifNoneMatchHeader;

    @VisibleForTesting
    public CacheInformation(long ifModifiedSinceHeader, String ifNoneMatchHeader) {
        this.ifModifiedSinceHeader = ifModifiedSinceHeader;
        this.ifNoneMatchHeader = ifNoneMatchHeader;
    }

    public CacheInformation(@Nonnull HttpServletRequest request) {
        Objects.requireNonNull(request, "The request is mandatory to build the caching information.");
        this.ifModifiedSinceHeader = request.getDateHeader("If-Modified-Since");
        this.ifNoneMatchHeader = request.getHeader("If-None-Match");
    }

    public boolean equals(Object other) {
        if (other instanceof CacheInformation) {
            CacheInformation otherCachingInformation = (CacheInformation)other;
            return this.ifModifiedSinceHeader == otherCachingInformation.ifModifiedSinceHeader && Objects.equals(this.ifNoneMatchHeader, otherCachingInformation.ifNoneMatchHeader);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.ifModifiedSinceHeader, this.ifNoneMatchHeader);
    }

    public boolean hasFreshContent(@Nonnull LocalDateTime pluginLastModifiedDate) {
        long pluginLastModifiedSeconds = pluginLastModifiedDate.toEpochSecond(ZoneOffset.UTC);
        return -1L == this.ifModifiedSinceHeader || pluginLastModifiedSeconds > this.ifModifiedSinceHeader;
    }

    public boolean hasNotFreshContent(@Nonnull LocalDateTime pluginLastModifiedDate) {
        return !this.hasFreshContent(pluginLastModifiedDate);
    }

    public boolean hasNotFreshContent(@Nonnull CacheableResponse httpServletResponse) {
        return !this.hasFreshContent(httpServletResponse);
    }

    public boolean hasFreshContent(@Nonnull CacheableResponse httpServletResponse) {
        String eTagToken = httpServletResponse.toETagToken().map(ETagToken::getValue).orElse(null);
        return Objects.isNull(eTagToken) || Objects.isNull(this.ifNoneMatchHeader) || !eTagToken.equals(this.ifNoneMatchHeader);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

