/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceDownloadUtils {
    private static final long ONE_YEAR_SECONDS = 31536000L;
    private static final long ONE_YEAR_MILLISECONDS = 31536000000L;

    public static void addCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String ... cacheControls) {
        boolean cacheDisabledByQueryParam = "false".equals(httpServletRequest.getParameter("cache"));
        if (Boolean.getBoolean("atlassian.disable.caches")) {
            httpServletResponse.setDateHeader("Expires", 0L);
            httpServletResponse.setHeader("Cache-Control", "no-cache, must-revalidate");
        } else if (!cacheDisabledByQueryParam) {
            httpServletResponse.setDateHeader("Expires", System.currentTimeMillis() + 31536000000L);
            httpServletResponse.setHeader("Cache-Control", "max-age=31536000");
            for (String cacheControl : cacheControls) {
                httpServletResponse.addHeader("Cache-Control", cacheControl);
            }
        }
    }

    public static void addPublicCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addCachingHeaders(httpServletRequest, httpServletResponse, "public");
    }

    public static void addPrivateCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addCachingHeaders(httpServletRequest, httpServletResponse, "private");
    }
}

