/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ForwardableResource
implements DownloadableResource {
    private ResourceLocation resourceLocation;

    public ForwardableResource(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    @Override
    public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    @Override
    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        try {
            String type = this.getContentType();
            if (StringUtils.isNotBlank((String)type)) {
                response.setContentType(type);
            }
            request.getRequestDispatcher(this.getLocation()).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new DownloadException(e.getMessage());
        }
        catch (IOException ioe) {
            throw new DownloadException(ioe.getMessage());
        }
    }

    @Override
    public void streamResource(OutputStream out) {
    }

    @Override
    public String getContentType() {
        return this.resourceLocation.getContentType();
    }

    protected String getLocation() {
        return this.resourceLocation.getLocation();
    }

    public String toString() {
        return "Forwardable Resource: " + this.resourceLocation.getLocation();
    }
}

