package com.atlassian.plugin.webresource.transformer;

import org.dom4j.Element;

/**
 * Factory to create URL aware web resource transformers
 *
 * @since v3.0
 */
public interface WebResourceTransformerFactory {

    /**
     * Return the URL builder for this transform
     *
     * @param parameters transformer parameters
     * @return an builder that contributes parameters to the URL
     */
    TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters);

    /**
     * Return the transformer for this transform
     *
     * @param parameters transformer parameters
     * @return a transformer that reads values from the url and transforms a webresource
     */
    UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters);

    /**
     * Return the transformer for this transform
     * <p>
     * The default implementation discards the {@code configElement} and calls
     * {@link #makeResourceTransformer(TransformerParameters)}.
     * This default implementation is provided for backwards compatibility. New implementations of this interface must
     * override this method if they need access to the {@code configElement}.
     *
     * @param configElement the transformer config from the plugin descriptor file
     * @param parameters    transformer parameters
     * @return a transformer that reads values from the url and transforms a webresource
     * @deprecated this method is added as a temporary solution to support Bitbucket Server's
     *         {@code AbstractUrlReadingClientWebFragmentTransformer}, and will be removed after Bitbucket 7.0 is
     *         released
     */
    @Deprecated
    default UrlReadingWebResourceTransformer makeResourceTransformer(Element configElement,
                                                                     TransformerParameters parameters) {
        return makeResourceTransformer(parameters);
    }
}
