/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.atlassian.plugin.web.descriptors.ContextProviderElementParser;
import com.atlassian.plugin.web.descriptors.WeightElementParser;
import com.atlassian.plugin.web.descriptors.WeightedDescriptor;
import com.atlassian.plugin.web.model.EmbeddedTemplateWebPanel;
import com.atlassian.plugin.web.model.ResourceTemplateWebPanel;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultWebPanelModuleDescriptor
extends AbstractModuleDescriptor<WebPanel>
implements WeightedDescriptor,
StateAware,
ConditionalDescriptor {
    public static final String XML_ELEMENT_NAME = "web-panel";
    private final WebInterfaceManager webInterfaceManager;
    private final HostContainer hostContainer;
    private Supplier<WebPanel> webPanelFactory;
    private Supplier<Condition> conditionFactory;
    private Supplier<ContextProvider> contextProviderFactory;
    private int weight;
    private String location;

    public DefaultWebPanelModuleDescriptor(HostContainer hostContainer, ModuleFactory moduleClassFactory, WebInterfaceManager webInterfaceManager) {
        super(moduleClassFactory);
        this.hostContainer = hostContainer;
        this.webInterfaceManager = webInterfaceManager;
    }

    public void init(final Plugin plugin, final Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = WeightElementParser.getWeight(element);
        this.location = element.attributeValue("location");
        this.conditionFactory = new Supplier<Condition>(){

            public Condition get() {
                return new ConditionElementParser(DefaultWebPanelModuleDescriptor.this.webInterfaceManager.getWebFragmentHelper()).makeConditions(plugin, element, 1);
            }
        };
        this.contextProviderFactory = new Supplier<ContextProvider>(){
            private ContextProvider contextProvider;

            public ContextProvider get() {
                if (this.contextProvider == null) {
                    this.contextProvider = new ContextProviderElementParser(DefaultWebPanelModuleDescriptor.this.webInterfaceManager.getWebFragmentHelper()).makeContextProvider(plugin, element);
                }
                return this.contextProvider;
            }
        };
        if (this.moduleClassName == null) {
            final ResourceDescriptor resource = this.getRequiredViewResource();
            final String filename = resource.getLocation();
            if (StringUtils.isEmpty((String)filename)) {
                final String body = (String)Preconditions.checkNotNull((Object)resource.getContent());
                this.webPanelFactory = new Supplier<WebPanel>(){

                    public WebPanel get() {
                        EmbeddedTemplateWebPanel panel = (EmbeddedTemplateWebPanel)DefaultWebPanelModuleDescriptor.this.hostContainer.create(EmbeddedTemplateWebPanel.class);
                        panel.setTemplateBody(body);
                        panel.setResourceType(DefaultWebPanelModuleDescriptor.this.getRequiredResourceType(resource));
                        panel.setPlugin(plugin);
                        return panel;
                    }
                };
            } else {
                this.webPanelFactory = new Supplier<WebPanel>(){

                    public WebPanel get() {
                        ResourceTemplateWebPanel panel = (ResourceTemplateWebPanel)DefaultWebPanelModuleDescriptor.this.hostContainer.create(ResourceTemplateWebPanel.class);
                        panel.setResourceFilename(filename);
                        panel.setResourceType(DefaultWebPanelModuleDescriptor.this.getRequiredResourceType(resource));
                        panel.setPlugin(plugin);
                        return panel;
                    }
                };
            }
        } else {
            final String moduleClassNameCopy = this.moduleClassName;
            this.webPanelFactory = new Supplier<WebPanel>(){

                public WebPanel get() {
                    return (WebPanel)DefaultWebPanelModuleDescriptor.this.moduleFactory.createModule(moduleClassNameCopy, (ModuleDescriptor)DefaultWebPanelModuleDescriptor.this);
                }
            };
        }
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@location").withError("The Web Panel location attribute is required.")});
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public Condition getCondition() {
        return (Condition)this.conditionFactory.get();
    }

    public ContextProvider getContextProvider() {
        return (ContextProvider)this.contextProviderFactory.get();
    }

    public WebPanel getModule() {
        return (WebPanel)this.webPanelFactory.get();
    }

    private String getRequiredResourceType(ResourceDescriptor resource) {
        String type = resource.getType();
        if (StringUtils.isEmpty((String)type)) {
            throw new PluginParseException("Resource element is lacking a type attribute.");
        }
        return type;
    }

    private ResourceDescriptor getRequiredViewResource() throws PluginParseException {
        Iterable resources = Iterables.filter((Iterable)this.getResourceDescriptors(), (Predicate)new Predicate<ResourceDescriptor>(){

            public boolean apply(ResourceDescriptor input) {
                return "view".equals(input.getName());
            }
        });
        Iterator iterator = resources.iterator();
        if (!iterator.hasNext()) {
            throw new PluginParseException("Required resource with name 'view' does not exist.");
        }
        return (ResourceDescriptor)iterator.next();
    }

    public void enabled() {
        super.enabled();
        this.webInterfaceManager.refresh();
    }

    public void disabled() {
        this.webInterfaceManager.refresh();
        super.disabled();
    }
}

