/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.renderer;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.web.renderer.RendererException;
import com.atlassian.plugin.web.renderer.WebPanelRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class StaticWebPanelRenderer
implements WebPanelRenderer {
    public static final StaticWebPanelRenderer RENDERER = new StaticWebPanelRenderer();
    public static final String RESOURCE_TYPE = "static";

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(String templateName, Plugin plugin, Map<String, Object> context, Writer writer) throws RendererException, IOException {
        InputStream in = null;
        try {
            in = this.loadTemplate(plugin, templateName);
            IOUtils.copy((InputStream)in, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public String renderFragment(String fragment, Plugin plugin, Map<String, Object> context) throws RendererException {
        return fragment;
    }

    @Override
    public void renderFragment(Writer writer, String fragment, Plugin plugin, Map<String, Object> context) throws RendererException, IOException {
        writer.write(fragment);
    }

    private InputStream loadTemplate(Plugin plugin, String templateName) throws IOException {
        InputStream in = plugin.getClassLoader().getResourceAsStream(templateName);
        if (in == null && (in = this.getClass().getResourceAsStream(templateName)) == null) {
            throw new RendererException(String.format("Static web panel template %s not found.", templateName));
        }
        return in;
    }
}

