/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.model;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.web.renderer.RendererException;
import com.atlassian.plugin.web.renderer.StaticWebPanelRenderer;
import com.atlassian.plugin.web.renderer.WebPanelRenderer;
import com.google.common.base.Preconditions;

public abstract class AbstractWebPanel
implements WebPanel {
    private final PluginAccessor pluginAccessor;
    protected Plugin plugin;
    private String resourceType;

    protected AbstractWebPanel(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = (String)Preconditions.checkNotNull((Object)resourceType);
    }

    protected final WebPanelRenderer getRenderer() {
        if ("static".equals(this.resourceType)) {
            return StaticWebPanelRenderer.RENDERER;
        }
        for (WebPanelRenderer webPanelRenderer : this.pluginAccessor.getEnabledModulesByClass(WebPanelRenderer.class)) {
            if (!((String)Preconditions.checkNotNull((Object)this.resourceType)).equals(webPanelRenderer.getResourceType())) continue;
            return webPanelRenderer;
        }
        throw new RendererException("No renderer found for resource type: " + this.resourceType);
    }
}

