/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.model;

import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.AbstractWebItem;
import com.atlassian.plugin.web.model.WebLink;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebLink
extends AbstractWebItem
implements WebLink {
    String url;
    String accessKey;
    String id;

    public DefaultWebLink(Element linkEl, WebFragmentHelper webFragmentHelper, ContextProvider contextProvider, WebFragmentModuleDescriptor descriptor) {
        super(webFragmentHelper, contextProvider, descriptor);
        this.url = linkEl.getTextTrim();
        this.accessKey = linkEl.attributeValue("accessKey");
        this.id = linkEl.attributeValue("linkId");
    }

    @Override
    public String getRenderedUrl(Map<String, Object> context) {
        context.putAll(this.getContextMap(context));
        return this.getWebFragmentHelper().renderVelocityFragment(this.url, context);
    }

    private boolean isRelativeUrl(String url) {
        return !url.startsWith("http://") && !url.startsWith("https://");
    }

    @Override
    public String getDisplayableUrl(HttpServletRequest req, Map<String, Object> context) {
        String renderedUrl = this.getRenderedUrl(context);
        if (this.isRelativeUrl(renderedUrl)) {
            return req.getContextPath() + renderedUrl;
        }
        return renderedUrl;
    }

    @Override
    public boolean hasAccessKey() {
        return this.accessKey != null && !"".equals(this.accessKey);
    }

    @Override
    public String getAccessKey(Map<String, Object> context) {
        context.putAll(this.getContextMap(context));
        return this.getWebFragmentHelper().renderVelocityFragment(this.accessKey, context);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

