/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.pluginns;

import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringXmlHostComponentProvider
implements HostComponentProvider,
BeanFactoryAware {
    private static final Logger log = Logger.getLogger(SpringXmlHostComponentProvider.class);
    public static final String HOST_COMPONENT_PROVIDER = "hostComponentProvider";
    private BeanFactory beanFactory;
    private List<String> beans;
    private Map<String, Class[]> interfaces = Collections.emptyMap();

    public void setRegistrations(List<String> names) {
        this.beans = names;
    }

    public void setInterfaces(Map<String, Class[]> interfaces) {
        this.interfaces = interfaces;
    }

    public void provide(ComponentRegistrar registrar) {
        HierarchicalBeanFactory hbf;
        BeanFactory parentBeanFactory;
        for (String name : this.beans) {
            Object bean = this.beanFactory.getBean(name);
            if (this.beanFactory.isSingleton(name)) {
                Class[] beanInterfaces = this.interfaces.get(name);
                if (beanInterfaces == null) {
                    beanInterfaces = this.findInterfaces(bean.getClass());
                }
                registrar.register(beanInterfaces).forInstance(bean).withName(name);
                continue;
            }
            log.warn((Object)("Cannot register bean " + name + " as it's scope is not singleton"));
        }
        if (this.beanFactory instanceof HierarchicalBeanFactory && (parentBeanFactory = (hbf = (HierarchicalBeanFactory)this.beanFactory).getParentBeanFactory()) != null) {
            try {
                HostComponentProvider provider = (HostComponentProvider)parentBeanFactory.getBean(HOST_COMPONENT_PROVIDER);
                if (provider != null) {
                    provider.provide(registrar);
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                log.info((Object)("Unable to find 'hostComponentProvider' in the parent bean factory " + parentBeanFactory));
            }
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    Class[] findInterfaces(Class cls) {
        ArrayList<Class> validInterfaces = new ArrayList<Class>();
        List allInterfaces = ClassUtils.getAllInterfaces((Class)cls);
        for (Class inf : allInterfaces) {
            if (inf.getName().startsWith("org.springframework") || inf.getName().startsWith("java.")) continue;
            validInterfaces.add(inf);
        }
        return validInterfaces.toArray(new Class[0]);
    }
}

