/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.pluginns;

import com.atlassian.plugin.spring.pluginns.SpringXmlHostComponentProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class PluginAvailableBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    public BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder holder, ParserContext ctx) {
        String isAvailable = ((Attr)source).getValue();
        if (Boolean.parseBoolean(isAvailable)) {
            BeanDefinition providerDef = this.registerHostComponent(ctx);
            List registrations = (List)providerDef.getPropertyValues().getPropertyValue("registrations").getValue();
            registrations.add(holder.getBeanName());
        }
        return holder;
    }

    private BeanDefinition registerHostComponent(ParserContext ctx) {
        BeanDefinition providerDef;
        BeanDefinitionRegistry registry = ctx.getRegistry();
        if (!registry.containsBeanDefinition("hostComponentProvider")) {
            BeanDefinitionBuilder providerDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(SpringXmlHostComponentProvider.class);
            providerDefBuilder.addPropertyValue("registrations", new ArrayList());
            providerDef = providerDefBuilder.getBeanDefinition();
            ctx.getRegistry().registerBeanDefinition("hostComponentProvider", providerDef);
        } else {
            providerDef = registry.getBeanDefinition("hostComponentProvider");
        }
        if (providerDef == null) {
            throw new IllegalStateException("Host component provider not found or created. This should never happen.");
        }
        return providerDef;
    }
}

