/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.util;

import java.util.LinkedList;
import java.util.List;

public class ClassLoaderStack {
    private static final ThreadLocal<List<ClassLoader>> classLoaderStack = new ThreadLocal<List<ClassLoader>>(){

        @Override
        protected List<ClassLoader> initialValue() {
            return new LinkedList<ClassLoader>();
        }
    };

    public static void push(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        classLoaderStack.get().add(0, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
    }

    public static ClassLoader pop() {
        if (classLoaderStack.get().isEmpty()) {
            return null;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoaderStack.get().remove(0));
        return currentClassLoader;
    }
}

