/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.internal.factory.transform.model;

import com.atlassian.plugin.util.validation.ValidationException;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class ComponentImport {
    private static final String INTERFACE = "interface";
    private final String key;
    private final Set<String> interfaces;
    private final String filter;
    private final Element source;

    public ComponentImport(Element element) {
        Preconditions.checkNotNull((Object)element);
        this.validate(element);
        this.source = element;
        this.key = element.attributeValue("key").trim();
        String filter = element.attributeValue("filter");
        this.filter = filter != null ? filter.trim() : null;
        this.interfaces = new LinkedHashSet<String>();
        if (element.attribute(INTERFACE) != null) {
            this.interfaces.add(element.attributeValue(INTERFACE).trim());
        } else {
            List compInterfaces = element.elements(INTERFACE);
            for (Element inf : compInterfaces) {
                this.interfaces.add(inf.getTextTrim());
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public Element getSource() {
        return this.source;
    }

    public String getFilter() {
        return this.filter;
    }

    private void validate(Element element) {
        if (element.attributeValue("key") == null) {
            throw new ValidationException("There were validation errors:", Collections.singletonList("The key is required"));
        }
        String interfaceAttribute = element.attributeValue(INTERFACE);
        if (interfaceAttribute != null) {
            if (interfaceAttribute.isEmpty()) {
                this.throwValidationException();
            }
        } else {
            Element interfaceElement = element.element(INTERFACE);
            if (interfaceElement == null) {
                this.throwValidationException();
            } else {
                String elementText = interfaceElement.getText();
                if (elementText == null || elementText.isEmpty()) {
                    this.throwValidationException();
                }
            }
        }
    }

    private void throwValidationException() {
        throw new ValidationException("There were validation errors:", Collections.singletonList("The interface must be specified either via the 'interface'\" +\n\"attribute or child 'interface' elements"));
    }
}

