/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook.dmz;

import java.util.Set;
import org.osgi.framework.Bundle;

public class PluginTypeDetector {
    private static PluginTypeDetector instance;
    private static Set<String> bundledPluginKeys;

    private PluginTypeDetector() {
    }

    public static PluginTypeDetector getInstance(Set<String> bundledPluginKeys) {
        if (instance == null) {
            instance = new PluginTypeDetector();
        }
        PluginTypeDetector.bundledPluginKeys = bundledPluginKeys;
        return instance;
    }

    public boolean isInternalPlugin(Bundle bundle) {
        String pluginKey = this.getPluginKeyOrSymbolicName(bundle);
        return pluginKey.startsWith("com.atlassian") || pluginKey.startsWith("com.riadalabs") || bundledPluginKeys.contains(pluginKey);
    }

    public boolean isSystemBundle(Bundle bundle) {
        return bundle.getBundleId() == 0L;
    }

    public String getPluginKeyOrSymbolicName(Bundle bundle) {
        String atlassianPluginKey = (String)bundle.getHeaders().get("Atlassian-Plugin-Key");
        if (atlassianPluginKey == null) {
            return bundle.getSymbolicName();
        }
        return atlassianPluginKey;
    }
}

