package com.atlassian.plugin.osgi.container.felix;

import java.util.function.Function;

public final class FelixUtils {

    private FelixUtils() {}

    public static void sortRestDescriptorFactory(Object[] services) {
        sortRestDescriptorFactory(services, service -> service.getClass().getName());
    }

    public static void sortRestDescriptorFactory(Object[] services, Function<Object, String> classNameProvider) {
        if (services == null) {
            return;
        }

        int oldRestIndex = -1;
        int newRestIndex = -1;

        for (int i = 0; i < services.length; i++) {
            Object service = services[i];
            if (classNameProvider.apply(service).equals("com.atlassian.plugins.rest.module.RestModuleDescriptorFactory")) {
                oldRestIndex = i;
            }
            if (classNameProvider.apply(service).equals("com.atlassian.plugins.rest.v2.descriptor.RestModuleDescriptorFactory")) {
                newRestIndex = i;
            }
        }

        // no need to change if only single or none REST factories are found
        if (oldRestIndex == -1 || newRestIndex == -1) {
            return;
        }

        boolean isNewRestFirst = newRestIndex < oldRestIndex;
        if (!isNewRestFirst) {
            // it is enough those factories are "sorted" between themselves
            Object oldFactory = services[oldRestIndex];
            services[oldRestIndex] = services[newRestIndex];
            services[newRestIndex] = oldFactory;
        }
    }
}
