package com.atlassian.plugin.osgi.hook;

import org.osgi.framework.wiring.BundleCapability;

import java.util.Set;

public class InternalPackageDetector {

    static final String ATTR_WIRING_PACKAGE = "osgi.wiring.package";

    private final Set<String> osgiPublicPackages;
    private final Set<String> osgiPublicPackagesExcludes;

    public InternalPackageDetector(Set<String> publicPackages, Set<String> publicPackagesExcludes) {
        this.osgiPublicPackages = publicPackages;
        this.osgiPublicPackagesExcludes = publicPackagesExcludes;
    }

    public boolean isInternalPackage(BundleCapability capability) {
        Object wiringPackageAttr = capability.getAttributes().get(ATTR_WIRING_PACKAGE);

        if (wiringPackageAttr instanceof String) {
            String wiringPackage = (String) wiringPackageAttr;

            boolean isPublic = osgiPublicPackages.stream()
                    .anyMatch(pattern -> new PackageMatcher(pattern, wiringPackage).match());

            boolean isNotExcluded = osgiPublicPackagesExcludes.stream()
                    .noneMatch(pattern -> new PackageMatcher(pattern, wiringPackage).match());

            boolean publicPackage = isPublic && isNotExcluded;
            return !publicPackage;
        }

        return false;
    }
}
