/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.spring;

import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.module.ContainerAccessor;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public class DefaultSpringContainerAccessor
implements ContainerAccessor {
    private final Object nativeBeanFactory;
    private final Method nativeCreateBeanMethod;
    private final Method nativeAutowireBeanMethod;
    private final Method nativeGetBeanMethod;
    private final Method nativeGetBeansOfTypeMethod;

    public DefaultSpringContainerAccessor(Object applicationContext) {
        Object beanFactory = null;
        try {
            Method m = applicationContext.getClass().getMethod("getAutowireCapableBeanFactory", new Class[0]);
            beanFactory = m.invoke(applicationContext, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new PluginException("Cannot find createBean method on registered bean factory: " + beanFactory, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException("Cannot access createBean method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.handleSpringMethodInvocationError(e);
        }
        this.nativeBeanFactory = beanFactory;
        try {
            this.nativeCreateBeanMethod = beanFactory.getClass().getMethod("createBean", Class.class, Integer.TYPE, Boolean.TYPE);
            this.nativeAutowireBeanMethod = beanFactory.getClass().getMethod("autowireBeanProperties", Object.class, Integer.TYPE, Boolean.TYPE);
            this.nativeGetBeanMethod = beanFactory.getClass().getMethod("getBean", String.class);
            this.nativeGetBeansOfTypeMethod = beanFactory.getClass().getMethod("getBeansOfType", Class.class);
            Preconditions.checkState((!Iterables.any((Iterable)Lists.newArrayList((Object[])new Method[]{this.nativeGetBeansOfTypeMethod, this.nativeAutowireBeanMethod, this.nativeCreateBeanMethod, this.nativeGetBeanMethod}), (Predicate)Predicates.isNull()) ? 1 : 0) != 0);
        }
        catch (NoSuchMethodException e) {
            throw new PluginException("Cannot find one or more methods on registered bean factory: " + this.nativeBeanFactory, (Throwable)e);
        }
    }

    private void handleSpringMethodInvocationError(InvocationTargetException e) {
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        throw new PluginException("Unable to invoke createBean", e.getCause());
    }

    public <T> T createBean(Class<T> clazz) {
        try {
            return clazz.cast(this.nativeCreateBeanMethod.invoke(this.nativeBeanFactory, clazz, AutowireStrategy.AUTOWIRE_AUTODETECT.ordinal(), false));
        }
        catch (IllegalAccessException e) {
            throw new PluginException("Unable to access createBean method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.handleSpringMethodInvocationError(e);
            return null;
        }
    }

    public <T> T injectBean(T bean) {
        try {
            this.nativeAutowireBeanMethod.invoke(this.nativeBeanFactory, bean, AutowireStrategy.AUTOWIRE_AUTODETECT.ordinal(), false);
        }
        catch (IllegalAccessException e) {
            throw new PluginException("Unable to access createBean method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.handleSpringMethodInvocationError(e);
        }
        return bean;
    }

    public <T> Collection<T> getBeansOfType(Class<T> interfaceClass) {
        try {
            Map beans = (Map)this.nativeGetBeansOfTypeMethod.invoke(this.nativeBeanFactory, interfaceClass);
            return beans.values();
        }
        catch (IllegalAccessException e) {
            throw new PluginException("Unable to access getBeansOfType method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.handleSpringMethodInvocationError(e);
            return null;
        }
    }

    public <T> T getBean(String id) {
        try {
            return (T)this.nativeGetBeanMethod.invoke(this.nativeBeanFactory, id);
        }
        catch (IllegalAccessException e) {
            throw new PluginException("Unable to access getBean method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.handleSpringMethodInvocationError(e);
            return null;
        }
    }

    public static enum AutowireStrategy {
        AUTOWIRE_NO,
        AUTOWIRE_BY_NAME,
        AUTOWIRE_BY_TYPE,
        AUTOWIRE_BY_CONSTRUCTOR,
        AUTOWIRE_AUTODETECT;

    }
}

