/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.util;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Resource;
import com.atlassian.annotations.Internal;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginPermission;
import com.atlassian.plugin.osgi.factory.transform.JarUtils;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.util.ClassBinaryScanner;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugin.util.ClassUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiHeaderUtil {
    static Logger log = LoggerFactory.getLogger(OsgiHeaderUtil.class);
    private static final String EMPTY_OSGI_VERSION = Version.emptyVersion.toString();
    private static final String STAR_PACKAGE = "*";
    private static final Predicate<String> JAVA_PACKAGE_FILTER = new Predicate<String>(){

        public boolean apply(String pkg) {
            return !pkg.startsWith("java.");
        }
    };
    private static final Predicate<String> JAVA_CLASS_FILTER = new Predicate<String>(){

        public boolean apply(String classEntry) {
            return !classEntry.startsWith("java/");
        }
    };

    public static Set<String> findReferredPackageNames(List<HostComponentRegistration> registrations) throws IOException {
        return OsgiHeaderUtil.findReferredPackagesInternal(registrations);
    }

    public static Map<String, String> findReferredPackageVersions(List<HostComponentRegistration> registrations, Map<String, String> packageVersions) throws IOException {
        Set<String> referredPackages = OsgiHeaderUtil.findReferredPackagesInternal(registrations);
        return OsgiHeaderUtil.matchPackageVersions(referredPackages, packageVersions);
    }

    @Deprecated
    public static String findReferredPackages(List<HostComponentRegistration> registrations) throws IOException {
        return OsgiHeaderUtil.findReferredPackages(registrations, Collections.emptyMap());
    }

    @Deprecated
    public static String findReferredPackages(List<HostComponentRegistration> registrations, Map<String, String> packageVersions) throws IOException {
        StringBuffer sb = new StringBuffer();
        HashSet<String> referredPackages = new HashSet<String>();
        HashSet<String> referredClasses = new HashSet<String>();
        if (registrations == null) {
            sb.append(",");
        } else {
            for (HostComponentRegistration reg : registrations) {
                HashSet classesToScan = new HashSet();
                for (Class<?> inf : reg.getMainInterfaceClasses()) {
                    ClassUtils.findAllTypes(inf, classesToScan);
                }
                for (Class inf : classesToScan) {
                    String clsName = inf.getName().replace('.', '/') + ".class";
                    OsgiHeaderUtil.crawlReferenceTree(clsName, referredClasses, referredPackages, 1);
                }
            }
            for (String pkg : referredPackages) {
                String version = packageVersions.get(pkg);
                sb.append(pkg);
                if (version != null) {
                    try {
                        Version.parseVersion((String)version);
                        sb.append(";version=").append(version);
                    }
                    catch (IllegalArgumentException ex) {
                        log.info("Unable to parse version: " + version);
                    }
                }
                sb.append(",");
            }
        }
        return sb.toString();
    }

    static Map<String, String> matchPackageVersions(Set<String> packageNames, Map<String, String> packageVersions) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (String pkg : packageNames) {
            String version = packageVersions.get(pkg);
            String effectiveKey = pkg;
            String effectiveValue = EMPTY_OSGI_VERSION;
            if (version != null) {
                try {
                    Version.parseVersion((String)version);
                    effectiveValue = version;
                }
                catch (IllegalArgumentException ex) {
                    log.info("Unable to parse version: " + version);
                }
            }
            output.put(effectiveKey, effectiveValue);
        }
        return ImmutableMap.copyOf(output);
    }

    static Set<String> findReferredPackagesInternal(List<HostComponentRegistration> registrations) throws IOException {
        HashSet<String> referredPackages = new HashSet<String>();
        HashSet<String> referredClasses = new HashSet<String>();
        if (registrations != null) {
            for (HostComponentRegistration reg : registrations) {
                HashSet classesToScan = new HashSet();
                for (Class<?> inf : reg.getMainInterfaceClasses()) {
                    ClassUtils.findAllTypes(inf, classesToScan);
                }
                for (Class inf : classesToScan) {
                    String clsName = inf.getName().replace('.', '/') + ".class";
                    OsgiHeaderUtil.crawlReferenceTree(clsName, referredClasses, referredPackages, 1);
                }
            }
        }
        return ImmutableSet.copyOf(referredPackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void crawlReferenceTree(String className, Set<String> scannedClasses, Set<String> packageImports, int level) throws IOException {
        if (level <= 0) {
            return;
        }
        if (className.startsWith("java/")) {
            return;
        }
        if (scannedClasses.contains(className)) {
            return;
        }
        scannedClasses.add(className);
        if (log.isDebugEnabled()) {
            log.debug("Crawling " + className);
        }
        try (ClassBinaryScanner.InputStreamResource classBinaryResource = null;){
            InputStream in = ClassLoaderUtils.getResourceAsStream((String)className, OsgiHeaderUtil.class);
            if (in == null) {
                log.error("Cannot find class: [" + className + "]");
                return;
            }
            classBinaryResource = new ClassBinaryScanner.InputStreamResource(in);
            ClassBinaryScanner.ScanResult scanResult = ClassBinaryScanner.scanClassBinary(new Clazz(new Analyzer(), className, (Resource)classBinaryResource));
            packageImports.addAll(Sets.filter(scanResult.getReferredPackages(), JAVA_PACKAGE_FILTER));
            Set referredClasses = Sets.filter(scanResult.getReferredClasses(), JAVA_CLASS_FILTER);
            for (String ref : referredClasses) {
                OsgiHeaderUtil.crawlReferenceTree(ref + ".class", scannedClasses, packageImports, level - 1);
            }
        }
    }

    public static Map<String, Map<String, String>> parseHeader(String header) {
        return new LinkedHashMap<String, Map<String, String>>(OSGiHeader.parseHeader((String)header).asMapMap());
    }

    public static String buildHeader(Map<String, Map<String, String>> values) {
        StringBuilder header = new StringBuilder();
        Iterator<Map.Entry<String, Map<String, String>>> i = values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = i.next();
            OsgiHeaderUtil.buildHeader(entry.getKey(), entry.getValue(), header);
            if (!i.hasNext()) continue;
            header.append(",");
        }
        return header.toString();
    }

    public static String buildHeader(String key, Map<String, String> attrs) {
        StringBuilder fullPkg = new StringBuilder();
        OsgiHeaderUtil.buildHeader(key, attrs, fullPkg);
        return fullPkg.toString();
    }

    private static void buildHeader(String key, Map<String, String> attrs, StringBuilder builder) {
        builder.append(key);
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                builder.append(";");
                builder.append(entry.getKey());
                builder.append("=\"");
                builder.append(entry.getValue());
                builder.append("\"");
            }
        }
    }

    public static String getPluginKey(Bundle bundle) {
        return OsgiHeaderUtil.getPluginKey(bundle.getSymbolicName(), bundle.getHeaders().get("Atlassian-Plugin-Key"), bundle.getHeaders().get("Bundle-Version"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPluginKey(File file) {
        JarFile jar;
        block4: {
            String string;
            jar = null;
            try {
                jar = new JarFile(file);
                Manifest manifest = jar.getManifest();
                if (manifest == null) break block4;
                string = OsgiHeaderUtil.getPluginKey(manifest);
            }
            catch (IOException eio) {
                try {
                    log.warn("Cannot read jar file '" + file + "': " + eio.getMessage());
                }
                catch (Throwable throwable) {
                    JarUtils.closeQuietly(jar);
                    throw throwable;
                }
                JarUtils.closeQuietly(jar);
            }
            JarUtils.closeQuietly(jar);
            return string;
        }
        JarUtils.closeQuietly(jar);
        return null;
    }

    public static String getPluginKey(Manifest mf) {
        return OsgiHeaderUtil.getPluginKey(OsgiHeaderUtil.getAttributeWithoutValidation(mf, "Bundle-SymbolicName"), OsgiHeaderUtil.getAttributeWithoutValidation(mf, "Atlassian-Plugin-Key"), OsgiHeaderUtil.getAttributeWithoutValidation(mf, "Bundle-Version"));
    }

    private static String getPluginKey(Object bundleName, Object atlKey, Object version) {
        Object key = atlKey;
        if (key == null) {
            key = bundleName + "-" + version;
        }
        return key.toString();
    }

    public static String generatePackageVersionString(Map<String, String> packages) {
        if (packages == null || packages.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> packageNames = new ArrayList<String>(packages.keySet());
        Collections.sort(packageNames);
        for (String packageName : packageNames) {
            sb.append(",");
            sb.append(packageName);
            String version = packages.get(packageName);
            if (version == null || version.equals(EMPTY_OSGI_VERSION)) continue;
            sb.append(";version=").append(version);
        }
        sb.delete(0, 1);
        return sb.toString();
    }

    public static String getValidatedAttribute(Manifest manifest, String key) {
        String value = OsgiHeaderUtil.getAttributeWithoutValidation(manifest, key);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0);
        return value;
    }

    public static String getNonEmptyAttribute(Manifest manifest, String key) {
        String attributeWithoutValidation = OsgiHeaderUtil.getAttributeWithoutValidation(manifest, key);
        Preconditions.checkArgument((!attributeWithoutValidation.isEmpty() ? 1 : 0) != 0);
        return attributeWithoutValidation;
    }

    public static String getAttributeWithoutValidation(Manifest manifest, String key) {
        return manifest.getMainAttributes().getValue(key);
    }

    @Internal
    public static PluginInformation extractOsgiPluginInformation(Manifest manifest, boolean requireVersion) {
        String bundleVersion = requireVersion ? OsgiHeaderUtil.getValidatedAttribute(manifest, "Bundle-Version") : OsgiHeaderUtil.getAttributeWithoutValidation(manifest, "Bundle-Version");
        String bundleVendor = OsgiHeaderUtil.getAttributeWithoutValidation(manifest, "Bundle-Vendor");
        String bundleDescription = OsgiHeaderUtil.getAttributeWithoutValidation(manifest, "Bundle-Description");
        PluginInformation pluginInformation = new PluginInformation();
        pluginInformation.setVersion(bundleVersion);
        pluginInformation.setDescription(bundleDescription);
        pluginInformation.setVendorName(bundleVendor);
        pluginInformation.setPermissions((Set)ImmutableSet.of((Object)PluginPermission.EXECUTE_JAVA));
        return pluginInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(PluginArtifact pluginArtifact) {
        block8: {
            Manifest manifest;
            InputStream manifestStream = pluginArtifact.getResourceAsStream("META-INF/MANIFEST.MF");
            if (manifestStream == null) break block8;
            try {
                manifest = new Manifest(manifestStream);
            }
            catch (IOException eio) {
                try {
                    try {
                        log.error("Cannot read manifest from plugin artifact '" + pluginArtifact.getName() + "': " + eio.getMessage());
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)manifestStream);
                    }
                }
                catch (PluginParseException epp) {
                    log.error("Cannot get manifest resource from plugin artifact '" + pluginArtifact.getName() + "': " + epp.getMessage());
                }
            }
            IOUtils.closeQuietly((InputStream)manifestStream);
            return manifest;
        }
        return null;
    }

    public static boolean containsStarPackage(String packageString) {
        Map<String, Map<String, String>> pkgs = OsgiHeaderUtil.parseHeader(packageString);
        return pkgs.containsKey(STAR_PACKAGE);
    }

    public static String moveStarPackageToEnd(String packageString, String pluginKey) {
        Map<String, Map<String, String>> currentPkgs = OsgiHeaderUtil.parseHeader(packageString);
        LinkedHashMap<String, Map<String, String>> starPkgs = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, Map<String, String>> orderedPkgs = new LinkedHashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : currentPkgs.entrySet()) {
            if (entry.getKey().contains(STAR_PACKAGE)) {
                starPkgs.put(entry.getKey(), entry.getValue());
                continue;
            }
            orderedPkgs.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Map<String, String>> entry : starPkgs.entrySet()) {
            log.debug("moving {} package to end for plugin {}", (Object)entry.getKey(), (Object)pluginKey);
            orderedPkgs.put(entry.getKey(), entry.getValue());
        }
        return OsgiHeaderUtil.buildHeader(orderedPkgs);
    }
}

