/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.module.ContainerAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.factory.OsgiPluginHelper;
import com.atlassian.plugin.osgi.spring.DefaultSpringContainerAccessor;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.resource.AlternativeDirectoryResourceLoader;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.Wire;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OsgiPluginInstalledHelper
implements OsgiPluginHelper {
    private static final Logger logger = LoggerFactory.getLogger(OsgiPluginInstalledHelper.class);
    private final ClassLoader bundleClassLoader;
    private final Bundle bundle;
    private final PackageAdmin packageAdmin;
    private volatile ContainerAccessor containerAccessor;
    private volatile ServiceTracker[] serviceTrackers;

    public OsgiPluginInstalledHelper(Bundle bundle, PackageAdmin packageAdmin) {
        this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle);
        this.packageAdmin = (PackageAdmin)Preconditions.checkNotNull((Object)packageAdmin);
        this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        return BundleClassLoaderAccessor.loadClass(this.getBundle(), clazz);
    }

    @Override
    public URL getResource(String name) {
        return this.bundleClassLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.bundleClassLoader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.bundleClassLoader;
    }

    @Override
    public Bundle install() {
        logger.debug("Not installing OSGi plugin '{}' since it's already installed.", (Object)this.bundle.getSymbolicName());
        throw new IllegalPluginStateException("Plugin '" + this.bundle.getSymbolicName() + "' has already been installed");
    }

    @Override
    public void onEnable(ServiceTracker ... serviceTrackers) throws OsgiContainerException {
        for (ServiceTracker svc : (ServiceTracker[])Preconditions.checkNotNull((Object)serviceTrackers)) {
            svc.open();
        }
        this.serviceTrackers = serviceTrackers;
    }

    @Override
    public void onDisable() throws OsgiContainerException {
        ServiceTracker[] serviceTrackers = this.serviceTrackers;
        if (serviceTrackers != null) {
            for (ServiceTracker svc : serviceTrackers) {
                svc.close();
            }
            this.serviceTrackers = null;
        }
        this.setPluginContainer(null);
    }

    @Override
    public void onUninstall() throws OsgiContainerException {
    }

    @Override
    public Set<String> getRequiredPlugins() {
        if (this.bundle.getState() == 2) {
            logger.debug("Bundle is in INSTALLED for {}", (Object)this.bundle.getSymbolicName());
            if (!this.packageAdmin.resolveBundles(new Bundle[]{this.bundle})) {
                logger.error("Cannot determine required plugins, cannot resolve bundle '{}'", (Object)this.bundle.getSymbolicName());
                return Collections.emptySet();
            }
            logger.debug("Bundle state is now {}", (Object)this.bundle.getState());
        }
        return this.getRequiredPluginKeys(this.bundle);
    }

    private Set<String> getRequiredPluginKeys(Bundle bundle) {
        String errMsg = null;
        HashSet<String> list = new HashSet<String>();
        try {
            Method getModules = bundle.getClass().getDeclaredMethod("getModules", new Class[0]);
            getModules.setAccessible(true);
            List modules = (List)getModules.invoke((Object)bundle, new Object[0]);
            for (Module module : modules) {
                List wires = module.getWires();
                for (Wire wire : wires) {
                    list.add(OsgiHeaderUtil.getPluginKey(wire.getExporter().getBundle()));
                }
            }
        }
        catch (InvocationTargetException ignored) {
            errMsg = "Completely unexpected InvocationTargetException during Felix Bundle getModules().  Has the underlying Felix changed since this code was written?";
        }
        catch (NoSuchMethodException ignored) {
            errMsg = "Completely unexpected NoSuchMethodException during Felix Bundle getModules().  Has the underlying Felix changed since this code was written?";
        }
        catch (IllegalAccessException ignored) {
            errMsg = "Completely unexpected IllegalAccessException during Felix Bundle getModules().  Has the underlying Felix changed since this code was written?";
        }
        if (errMsg != null) {
            throw new IllegalStateException(errMsg);
        }
        return list;
    }

    @Override
    public void setPluginContainer(Object container) {
        this.containerAccessor = container == null ? null : (container instanceof ContainerAccessor ? (ContainerAccessor)container : new DefaultSpringContainerAccessor(container));
    }

    @Override
    public ContainerAccessor getContainerAccessor() {
        return this.containerAccessor;
    }

    @Override
    public ContainerAccessor getRequiredContainerAccessor() throws IllegalPluginStateException {
        if (this.containerAccessor == null) {
            throw new IllegalStateException("Cannot create object because the plugin container is unavailable for bundle '" + this.bundle.getSymbolicName() + "'");
        }
        return this.containerAccessor;
    }

    @Override
    public boolean isRemotePlugin() {
        return (Boolean)Option.option((Object)this.getBundle().getHeaders()).fold(Suppliers.alwaysFalse(), (Function)new Function<Dictionary, Boolean>(){

            public Boolean apply(Dictionary headers) {
                return headers.get("Remote-Plugin") != null;
            }
        });
    }
}

