/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundlePlugin;
import com.atlassian.plugin.osgi.factory.OsgiPluginXmlDescriptorParserFactory;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ranges;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiBundleFactory
extends AbstractPluginFactory {
    private static final Logger log = LoggerFactory.getLogger(OsgiBundleFactory.class);
    private final OsgiContainerManager osgi;
    private final PluginEventManager pluginEventManager;
    private final String pluginDescriptorFileName;

    public OsgiBundleFactory(OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this("atlassian-plugin.xml", osgi, pluginEventManager);
    }

    public OsgiBundleFactory(String pluginDescriptorFileName, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        super((DescriptorParserFactory)new OsgiPluginXmlDescriptorParserFactory(), (Set)ImmutableSet.of());
        this.pluginDescriptorFileName = (String)Preconditions.checkNotNull((Object)pluginDescriptorFileName);
        this.osgi = (OsgiContainerManager)Preconditions.checkNotNull((Object)osgi, (Object)"The osgi container is required");
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager, (Object)"The plugin event manager is required");
    }

    protected InputStream getDescriptorInputStream(PluginArtifact pluginArtifact) {
        return pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
    }

    protected Predicate<Integer> isValidPluginsVersion() {
        return Ranges.atLeast((Comparable)Integer.valueOf(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        InputStream descriptorStream;
        block4: {
            block5: {
                String string;
                Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The plugin artifact is required");
                descriptorStream = null;
                try {
                    descriptorStream = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
                    if (null != descriptorStream) break block4;
                    Manifest manifest = OsgiHeaderUtil.getManifest(pluginArtifact);
                    if (null == manifest || null == manifest.getMainAttributes().getValue("Bundle-SymbolicName")) break block5;
                    string = OsgiHeaderUtil.getPluginKey(manifest);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(descriptorStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)descriptorStream);
                return string;
            }
            String string = null;
            IOUtils.closeQuietly((InputStream)descriptorStream);
            return string;
        }
        String string = null;
        IOUtils.closeQuietly((InputStream)descriptorStream);
        return string;
    }

    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) {
        Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The plugin artifact is required");
        Preconditions.checkNotNull((Object)moduleDescriptorFactory, (Object)"The module descriptor factory is required");
        String pluginKey = this.canCreate(pluginArtifact);
        if (null == pluginKey) {
            log.warn("Unable to load plugin from '{}'", (Object)pluginArtifact);
            return new UnloadablePlugin("PluginArtifact has no manifest or is not a bundle: '" + pluginArtifact + "'");
        }
        return new OsgiBundlePlugin(this.osgi, pluginKey, pluginArtifact);
    }
}

