/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.module.ContainerAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.factory.OsgiPluginHelper;
import com.atlassian.plugin.osgi.spring.DefaultSpringContainerAccessor;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.resource.AlternativeDirectoryResourceLoader;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OsgiPluginInstalledHelper
implements OsgiPluginHelper {
    private static final Logger logger = LoggerFactory.getLogger(OsgiPluginInstalledHelper.class);
    private final ClassLoader bundleClassLoader;
    private final Bundle bundle;
    private final PackageAdmin packageAdmin;
    private volatile ContainerAccessor containerAccessor;
    private volatile ServiceTracker[] serviceTrackers;

    public OsgiPluginInstalledHelper(Bundle bundle, PackageAdmin packageAdmin) {
        this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle);
        this.packageAdmin = (PackageAdmin)Preconditions.checkNotNull((Object)packageAdmin);
        this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        return BundleClassLoaderAccessor.loadClass(this.getBundle(), clazz);
    }

    @Override
    public URL getResource(String name) {
        return this.bundleClassLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.bundleClassLoader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.bundleClassLoader;
    }

    @Override
    public Bundle install() {
        logger.debug("Not installing OSGi plugin '{}' since it's already installed.", (Object)this.bundle.getSymbolicName());
        throw new IllegalPluginStateException("Plugin '" + this.bundle.getSymbolicName() + "' has already been installed");
    }

    @Override
    public void onEnable(ServiceTracker ... serviceTrackers) throws OsgiContainerException {
        for (ServiceTracker svc : (ServiceTracker[])Preconditions.checkNotNull((Object)serviceTrackers)) {
            svc.open();
        }
        this.serviceTrackers = serviceTrackers;
    }

    @Override
    public void onDisable() throws OsgiContainerException {
        ServiceTracker[] serviceTrackers = this.serviceTrackers;
        if (serviceTrackers != null) {
            for (ServiceTracker svc : serviceTrackers) {
                svc.close();
            }
            this.serviceTrackers = null;
        }
        this.setPluginContainer(null);
    }

    @Override
    public void onUninstall() throws OsgiContainerException {
    }

    @Override
    public Set<String> getRequiredPlugins() {
        if (this.bundle.getState() == 2) {
            logger.debug("Bundle is in INSTALLED for {}", (Object)this.bundle.getSymbolicName());
            this.packageAdmin.resolveBundles(new Bundle[]{this.bundle});
            logger.debug("Bundle state is now {}", (Object)this.bundle.getState());
        }
        HashSet<String> keys = new HashSet<String>();
        this.getRequiredPluginsFromExports(keys);
        return keys;
    }

    private void getRequiredPluginsFromExports(Set<String> keys) {
        HashSet<String> imports = new HashSet<String>(OsgiHeaderUtil.parseHeader((String)this.getBundle().getHeaders().get("Import-Package")).keySet());
        imports.addAll(OsgiHeaderUtil.parseHeader((String)this.getBundle().getHeaders().get("DynamicImport-Package")).keySet());
        for (String imp : imports) {
            ExportedPackage[] exports = this.packageAdmin.getExportedPackages(imp);
            if (exports == null) continue;
            block1: for (ExportedPackage export : exports) {
                Bundle[] importingBundles = export.getImportingBundles();
                if (importingBundles == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (this.getBundle() != importingBundle) continue;
                    keys.add(OsgiHeaderUtil.getPluginKey(export.getExportingBundle()));
                    continue block1;
                }
            }
        }
    }

    @Override
    public void setPluginContainer(Object container) {
        this.containerAccessor = container == null ? null : (container instanceof ContainerAccessor ? (ContainerAccessor)container : new DefaultSpringContainerAccessor(container));
    }

    @Override
    public ContainerAccessor getContainerAccessor() {
        return this.containerAccessor;
    }

    @Override
    public ContainerAccessor getRequiredContainerAccessor() throws IllegalPluginStateException {
        if (this.containerAccessor == null) {
            throw new IllegalStateException("Cannot create object because the plugin container is unavailable.");
        }
        return this.containerAccessor;
    }

    @Override
    public boolean isRemotePlugin() {
        return (Boolean)Option.option((Object)this.getBundle().getHeaders()).fold(Suppliers.alwaysFalse(), (Function)new Function<Dictionary, Boolean>(){

            public Boolean apply(Dictionary headers) {
                return headers.get("Remote-Plugin") != null;
            }
        });
    }
}

