/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactBackedPlugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginPermission;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.impl.AbstractPlugin;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.atlassian.plugin.util.resource.AlternativeDirectoryResourceLoader;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public final class OsgiBundlePlugin
extends AbstractPlugin
implements PluginArtifactBackedPlugin {
    private final Bundle bundle;
    private final Date dateLoaded;
    private final ClassLoader bundleClassLoader;
    private final SynchronousBundleListener bundleStartStopListener;
    private final PluginArtifact pluginArtifact;

    public OsgiBundlePlugin(final Bundle bundle, String key, PluginArtifact pluginArtifact) {
        this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle);
        this.pluginArtifact = (PluginArtifact)Preconditions.checkNotNull((Object)pluginArtifact);
        this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
        this.bundleStartStopListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                if (bundleEvent.getBundle() == bundle) {
                    if (bundleEvent.getType() == 256) {
                        OsgiBundlePlugin.this.setPluginState(PluginState.DISABLED);
                    } else if (bundleEvent.getType() == 2) {
                        OsgiBundlePlugin.this.setPluginState(PluginState.ENABLED);
                    }
                }
            }
        };
        PluginInformation pluginInformation = new PluginInformation();
        pluginInformation.setDescription((String)bundle.getHeaders().get("Bundle-Description"));
        pluginInformation.setVersion((String)bundle.getHeaders().get("Bundle-Version"));
        pluginInformation.setVendorName((String)bundle.getHeaders().get("Bundle-Vendor"));
        pluginInformation.setPermissions((Set)ImmutableSet.of((Object)PluginPermission.EXECUTE_JAVA));
        this.dateLoaded = new Date();
        this.setPluginsVersion(2);
        this.setName((String)bundle.getHeaders().get("Bundle-Name"));
        this.setKey(key);
        this.setPluginInformation(pluginInformation);
        this.setSystemPlugin(false);
    }

    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    public Date getDateInstalled() {
        long date = this.getPluginArtifact().toFile().lastModified();
        if (date == 0L) {
            date = this.getDateLoaded().getTime();
        }
        return new Date(date);
    }

    public boolean isUninstallable() {
        return true;
    }

    public boolean isDeleteable() {
        return true;
    }

    public boolean isDynamicallyLoaded() {
        return true;
    }

    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        return BundleClassLoaderAccessor.loadClass(this.bundle, clazz);
    }

    public URL getResource(String name) {
        return this.bundleClassLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.bundleClassLoader.getResourceAsStream(name);
    }

    protected void uninstallInternal() {
        try {
            if (this.bundle.getState() != 1) {
                this.bundle.uninstall();
            }
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected PluginState enableInternal() {
        this.getLog().debug("Enabling OSGi bundled plugin '{}'", (Object)this.getKey());
        try {
            if (this.bundle.getHeaders().get("Fragment-Host") == null) {
                this.getLog().debug("Plugin '{}' bundle is NOT a fragment, starting.", (Object)this.getKey());
                this.bundle.start();
                this.bundle.getBundleContext().addBundleListener((BundleListener)this.bundleStartStopListener);
            } else {
                this.getLog().debug("Plugin '{}' bundle is a fragment, not doing anything.", (Object)this.getKey());
            }
            return PluginState.ENABLED;
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected void disableInternal() {
        try {
            if (this.bundle.getState() == 32) {
                this.bundle.stop();
            }
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.bundleClassLoader;
    }

    public PluginArtifact getPluginArtifact() {
        return this.pluginArtifact;
    }
}

