/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.model;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.util.validation.ValidationPattern;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentImport {
    private final String key;
    private final Set<String> interfaces;
    private final String filter;
    private final Element source;

    public ComponentImport(Element element) throws PluginParseException {
        Validate.notNull((Object)element);
        ValidationPattern.createPattern().rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@key").withError("The key is required"), ValidationPattern.test((String)"(@interface and string-length(@interface) > 0) or (interface and string-length(interface[1]) > 0)").withError("The interface must be specified either via the 'interface'attribute or child 'interface' elements")}).evaluate((Node)element);
        this.source = element;
        this.key = element.attributeValue("key");
        this.filter = element.attributeValue("filter");
        this.interfaces = new HashSet<String>();
        if (element.attribute("interface") != null) {
            this.interfaces.add(element.attributeValue("interface"));
        } else {
            List compInterfaces = element.elements("interface");
            for (Element inf : compInterfaces) {
                this.interfaces.add(inf.getTextTrim());
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public Element getSource() {
        return this.source;
    }

    public String getFilter() {
        return this.filter;
    }
}

