/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.felix;

import com.atlassian.plugin.util.ClassLoaderUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.pkgscanner.DefaultOsgiVersionConverter;
import org.twdata.pkgscanner.ExportPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExportBuilderUtils {
    private static Logger LOG = LoggerFactory.getLogger(ExportBuilderUtils.class);
    private static final DefaultOsgiVersionConverter converter = new DefaultOsgiVersionConverter();
    private static final String EMPTY_OSGI_VERSION = Version.emptyVersion.toString();
    private static final Function<String, String> CONVERT_VERSION = new Function<String, String>(){

        public String apply(String from) {
            if (from != null && from.trim().length() > 0) {
                return converter.getVersion(from);
            }
            return EMPTY_OSGI_VERSION;
        }
    };

    private ExportBuilderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> parseExportFile(String exportFilePath) {
        Properties props = new Properties();
        InputStream in = null;
        try {
            in = ClassLoaderUtils.getResourceAsStream((String)exportFilePath, ExportBuilderUtils.class);
            props.load(in);
        }
        catch (IOException e) {
            LOG.warn("Problem occurred while processing package export:" + exportFilePath, (Throwable)e);
            ImmutableMap immutableMap = ImmutableMap.of();
            return immutableMap;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return Maps.transformValues((Map)Maps.fromProperties((Properties)props), CONVERT_VERSION);
    }

    static void copyUnlessExist(final Map<String, String> dest, Map<String, String> src) {
        dest.putAll(Maps.filterKeys(src, (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return !dest.containsKey(key);
            }
        }));
    }

    static Map<String, String> toMap(Iterable<ExportPackage> exportPackages) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (ExportPackage pkg : exportPackages) {
            String version = pkg.getVersion() == null ? EMPTY_OSGI_VERSION : pkg.getVersion();
            output.put(pkg.getPackageName(), version);
        }
        return ImmutableMap.copyOf(output);
    }
}

