/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.util;

import com.atlassian.plugin.osgi.util.OpCodes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Clazz {
    static final byte[] SkipTable = new byte[]{0, -1, -1, 4, 4, 8, 8, -1, 2, 4, 4, 4, 4};
    String className;
    Object[] pool;
    int[] intPool;
    Map packageImports = new HashMap();
    Set classImports = new HashSet();
    String path;
    int minor = 0;
    int major = 0;
    String sourceFile;
    String superClassName;
    Set xref;
    Set classes;
    Set descriptors;
    int forName = 0;
    int class$ = 0;

    public Clazz(String path) {
        this.path = path;
    }

    public Clazz(String path, InputStream in) throws IOException {
        this.path = path;
        DataInputStream din = new DataInputStream(in);
        this.parseClassFile(din);
        din.close();
    }

    Set parseClassFile(DataInputStream in) throws IOException {
        this.xref = new HashSet();
        this.classes = new HashSet();
        this.descriptors = new HashSet();
        boolean crawl = false;
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a valid class file (no CAFEBABE header)");
        }
        this.minor = in.readUnsignedShort();
        this.major = in.readUnsignedShort();
        int count = in.readUnsignedShort();
        this.pool = new Object[count];
        this.intPool = new int[count];
        block10: for (int poolIndex = 1; poolIndex < count; ++poolIndex) {
            byte tag = in.readByte();
            switch (tag) {
                case 0: {
                    break block10;
                }
                case 1: {
                    this.constantUtf8(in, poolIndex);
                    continue block10;
                }
                case 5: {
                    this.constantLong(in, poolIndex);
                    ++poolIndex;
                    continue block10;
                }
                case 6: {
                    this.constantDouble(in, poolIndex);
                    ++poolIndex;
                    continue block10;
                }
                case 7: {
                    this.constantClass(in, poolIndex);
                    continue block10;
                }
                case 8: {
                    this.constantString(in, poolIndex);
                    continue block10;
                }
                case 10: {
                    this.methodRef(in, poolIndex);
                    continue block10;
                }
                case 12: {
                    this.nameAndType(in, poolIndex, tag);
                    continue block10;
                }
                default: {
                    if (tag == 2) {
                        throw new IOException("Invalid tag " + tag);
                    }
                    in.skipBytes(SkipTable[tag]);
                }
            }
        }
        this.pool(this.pool, this.intPool);
        int access_flags = in.readUnsignedShort();
        int this_class = in.readUnsignedShort();
        int super_class = in.readUnsignedShort();
        String supr = (String)this.pool[this.intPool[super_class]];
        if (supr != null) {
            this.superClassName = supr;
            this.addReference(supr);
        }
        this.className = (String)this.pool[this.intPool[this_class]];
        int interfacesCount = in.readUnsignedShort();
        in.skipBytes(interfacesCount * 2);
        int fieldsCount = in.readUnsignedShort();
        for (int i = 0; i < fieldsCount; ++i) {
            access_flags = in.readUnsignedShort();
            int name_index = in.readUnsignedShort();
            int descriptor_index = in.readUnsignedShort();
            String name = this.pool[name_index].toString();
            if (name.startsWith("class$")) {
                crawl = true;
            }
            this.descriptors.add(new Integer(descriptor_index));
            this.doAttributes(in, false);
        }
        if (crawl) {
            this.forName = this.findMethod("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            this.class$ = this.findMethod(this.className, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
        }
        int methodCount = in.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            access_flags = in.readUnsignedShort();
            int name_index = in.readUnsignedShort();
            int descriptor_index = in.readUnsignedShort();
            String s = (String)this.pool[name_index];
            this.descriptors.add(new Integer(descriptor_index));
            this.doAttributes(in, crawl);
        }
        this.doAttributes(in, false);
        Iterator e = this.classes.iterator();
        while (e.hasNext()) {
            short class_index = ((Integer)e.next()).shortValue();
            this.doClassReference((String)this.pool[class_index]);
        }
        for (Integer index : this.descriptors) {
            String prototype = (String)this.pool[index];
            if (prototype != null) {
                this.parseDescriptor(prototype);
                continue;
            }
            System.err.println("Unrecognized descriptor: " + index);
        }
        Set xref = this.xref;
        this.reset();
        return xref;
    }

    protected void pool(Object[] pool, int[] intPool) {
    }

    protected void nameAndType(DataInputStream in, int poolIndex, byte tag) throws IOException {
        int name_index = in.readUnsignedShort();
        int descriptor_index = in.readUnsignedShort();
        this.descriptors.add(new Integer(descriptor_index));
        this.pool[poolIndex] = new Assoc(tag, name_index, descriptor_index);
    }

    private void methodRef(DataInputStream in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(10, class_index, name_and_type_index);
    }

    private void constantString(DataInputStream in, int poolIndex) throws IOException {
        int string_index;
        this.intPool[poolIndex] = string_index = in.readUnsignedShort();
    }

    protected void constantClass(DataInputStream in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        this.classes.add(new Integer(class_index));
        this.intPool[poolIndex] = class_index;
    }

    protected void constantDouble(DataInputStream in, int poolIndex) throws IOException {
        in.skipBytes(8);
    }

    protected void constantLong(DataInputStream in, int poolIndex) throws IOException {
        in.skipBytes(8);
    }

    protected void constantUtf8(DataInputStream in, int poolIndex) throws IOException {
        String name = in.readUTF();
        this.xref.add(name);
        this.pool[poolIndex] = name;
    }

    private int findMethod(String clazz, String methodname, String descriptor) {
        for (int i = 1; i < this.pool.length; ++i) {
            int class_index;
            int class_name_index;
            if (!(this.pool[i] instanceof Assoc)) continue;
            Assoc methodref = (Assoc)this.pool[i];
            if (methodref.tag != 10 || !clazz.equals(this.pool[class_name_index = this.intPool[class_index = methodref.a]])) continue;
            int name_and_type_index = methodref.b;
            Assoc name_and_type = (Assoc)this.pool[name_and_type_index];
            if (name_and_type.tag != 12) continue;
            int name_index = name_and_type.a;
            int type_index = name_and_type.b;
            if (!methodname.equals(this.pool[name_index]) || !descriptor.equals(this.pool[type_index])) continue;
            return i;
        }
        return -1;
    }

    private void doClassReference(String next) {
        if (next != null) {
            String normalized = Clazz.normalize(next);
            if (normalized != null) {
                this.classReference(normalized);
            }
        } else {
            throw new IllegalArgumentException("Invalid class, parent=");
        }
    }

    private void doAttributes(DataInputStream in, boolean crawl) throws IOException {
        int attributesCount = in.readUnsignedShort();
        for (int j = 0; j < attributesCount; ++j) {
            this.doAttribute(in, crawl);
        }
    }

    private void doAttribute(DataInputStream in, boolean crawl) throws IOException {
        int attribute_name_index = in.readUnsignedShort();
        String attributeName = (String)this.pool[attribute_name_index];
        long attribute_length = in.readInt();
        attribute_length &= 0xFFFFL;
        if ("RuntimeVisibleAnnotations".equals(attributeName)) {
            this.doAnnotations(in);
        } else if ("RuntimeVisibleParameterAnnotations".equals(attributeName)) {
            this.doParameterAnnotations(in);
        } else if ("SourceFile".equals(attributeName)) {
            this.doSourceFile(in);
        } else if ("Code".equals(attributeName) && crawl) {
            this.doCode(in);
        } else {
            if (attribute_length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Attribute > 2Gb");
            }
            in.skipBytes((int)attribute_length);
        }
    }

    private void doCode(DataInputStream in) throws IOException {
        in.readUnsignedShort();
        in.readUnsignedShort();
        int code_length = in.readInt();
        byte[] code = new byte[code_length];
        in.readFully(code);
        this.crawl(code);
        int exception_table_length = in.readUnsignedShort();
        in.skipBytes(exception_table_length * 8);
        this.doAttributes(in, false);
    }

    protected void crawl(byte[] code) {
        ByteBuffer bb = ByteBuffer.wrap(code);
        bb.order(ByteOrder.BIG_ENDIAN);
        int lastReference = -1;
        block7: while (bb.remaining() > 0) {
            int instruction = 0xFF & bb.get();
            switch (instruction) {
                case 18: {
                    lastReference = 0xFF & bb.get();
                    continue block7;
                }
                case 19: {
                    lastReference = 0xFFFF & bb.getShort();
                    continue block7;
                }
                case 184: {
                    int methodref = 0xFFFF & bb.getShort();
                    if (methodref != this.forName && methodref != this.class$ || lastReference == -1 || !(this.pool[this.intPool[lastReference]] instanceof String)) continue block7;
                    String clazz = (String)this.pool[this.intPool[lastReference]];
                    this.doClassReference(clazz.replace('.', '/'));
                    continue block7;
                }
                case 170: {
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    int deflt = bb.getInt();
                    int low = bb.getInt();
                    int high = bb.getInt();
                    bb.position(bb.position() + (high - low + 1) * 4);
                    lastReference = -1;
                    continue block7;
                }
                case 171: {
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    int deflt = bb.getInt();
                    int npairs = bb.getInt();
                    bb.position(bb.position() + npairs * 8);
                    lastReference = -1;
                    continue block7;
                }
            }
            lastReference = -1;
            bb.position(bb.position() + OpCodes.OFFSETS[instruction]);
        }
    }

    private void doSourceFile(DataInputStream in) throws IOException {
        int sourcefile_index = in.readUnsignedShort();
        this.sourceFile = this.pool[sourcefile_index].toString();
    }

    private void doParameterAnnotations(DataInputStream in) throws IOException {
        int num_parameters = in.readUnsignedByte();
        for (int p = 0; p < num_parameters; ++p) {
            int num_annotations = in.readUnsignedShort();
            for (int a = 0; a < num_annotations; ++a) {
                this.doAnnotation(in);
            }
        }
    }

    private void doAnnotations(DataInputStream in) throws IOException {
        int num_annotations = in.readUnsignedShort();
        for (int a = 0; a < num_annotations; ++a) {
            this.doAnnotation(in);
        }
    }

    private void doAnnotation(DataInputStream in) throws IOException {
        int type_index = in.readUnsignedShort();
        this.descriptors.add(new Integer(type_index));
        int num_element_value_pairs = in.readUnsignedShort();
        for (int v = 0; v < num_element_value_pairs; ++v) {
            in.readUnsignedShort();
            this.doElementValue(in);
        }
    }

    private void doElementValue(DataInputStream in) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                in.readUnsignedShort();
                break;
            }
            case 101: {
                int type_name_index = in.readUnsignedShort();
                this.descriptors.add(new Integer(type_name_index));
                in.readUnsignedShort();
                break;
            }
            case 99: {
                int class_info_index = in.readUnsignedShort();
                this.descriptors.add(new Integer(class_info_index));
                break;
            }
            case 64: {
                this.doAnnotation(in);
                break;
            }
            case 91: {
                int num_values = in.readUnsignedShort();
                for (int i = 0; i < num_values; ++i) {
                    this.doElementValue(in);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Annotation ElementValue tag " + tag);
            }
        }
    }

    void classReference(String clazz) {
        String pack = Clazz.getPackage(clazz);
        this.packageReference(pack);
        this.classImports.add(clazz);
    }

    void packageReference(String pack) {
        if (pack.indexOf(60) >= 0) {
            System.out.println("Oops: " + pack);
        }
        if (!this.packageImports.containsKey(pack)) {
            this.packageImports.put(pack, new HashMap());
        }
    }

    void parseDescriptor(String prototype) {
        this.addReference(prototype);
        StringTokenizer st = new StringTokenizer(prototype, "(;)", true);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals("(")) continue;
            String token = st.nextToken();
            while (!token.equals(")")) {
                this.addReference(token);
                token = st.nextToken();
            }
            token = st.nextToken();
            this.addReference(token);
        }
    }

    private void addReference(String token) {
        while (token.startsWith("[")) {
            token = token.substring(1);
        }
        if (token.startsWith("L")) {
            String clazz = Clazz.normalize(token.substring(1));
            if (clazz.startsWith("java/")) {
                return;
            }
            this.classReference(clazz);
        }
    }

    static String normalize(String s) {
        if (s.startsWith("[L")) {
            return Clazz.normalize(s.substring(2));
        }
        if (s.startsWith("[")) {
            if (s.length() == 2) {
                return null;
            }
            return Clazz.normalize(s.substring(1));
        }
        if (s.endsWith(";")) {
            return Clazz.normalize(s.substring(0, s.length() - 1));
        }
        return s + ".class";
    }

    public static String getPackage(String clazz) {
        int n = clazz.lastIndexOf(47);
        if (n < 0) {
            return ".";
        }
        return clazz.substring(0, n).replace('/', '.');
    }

    public Map getReferred() {
        return this.packageImports;
    }

    public Set getReferredClasses() {
        return this.classImports;
    }

    String getClassName() {
        return this.className;
    }

    public String getPath() {
        return this.path;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public Set xref(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        Set set = this.parseClassFile(din);
        din.close();
        return set;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void reset() {
        this.pool = null;
        this.intPool = null;
        this.xref = null;
        this.classes = null;
        this.descriptors = null;
    }

    protected static class Assoc {
        byte tag;
        int a;
        int b;

        Assoc(byte tag, int a, int b) {
            this.tag = tag;
            this.a = a;
            this.b = b;
        }
    }
}

