/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.util;

import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import com.atlassian.plugin.util.resource.NoOpAlternativeResourceLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.lang.Validate;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassLoaderAccessor {
    public static ClassLoader getClassLoader(Bundle bundle, AlternativeResourceLoader alternativeResourceLoader) {
        return new BundleClassLoader(bundle, alternativeResourceLoader);
    }

    public static <T> Class<T> loadClass(Bundle bundle, String name) throws ClassNotFoundException {
        Validate.notNull((Object)bundle, (String)"The bundle is required");
        Class loadedClass = bundle.loadClass(name);
        return loadedClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BundleClassLoader
    extends ClassLoader {
        private final Bundle bundle;
        private final AlternativeResourceLoader altResourceLoader;

        public BundleClassLoader(Bundle bundle, AlternativeResourceLoader altResourceLoader) {
            super(null);
            Validate.notNull((Object)bundle, (String)"The bundle must not be null");
            if (altResourceLoader == null) {
                altResourceLoader = new NoOpAlternativeResourceLoader();
            }
            this.altResourceLoader = altResourceLoader;
            this.bundle = bundle;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            URL resource;
            Enumeration e = this.bundle.getResources(name);
            if (e == null) {
                e = new IteratorEnumeration(Collections.emptyList().iterator());
            } else if (!e.hasMoreElements() && (resource = this.findResource(name)) != null) {
                e = new IteratorEnumeration(Arrays.asList(resource).iterator());
            }
            return e;
        }

        @Override
        public URL findResource(String name) {
            URL url = this.altResourceLoader.getResource(name);
            if (url == null) {
                url = this.bundle.getResource(name);
            }
            return url;
        }
    }
}

