/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.module.ContainerAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiPluginHelper;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.osgi.framework.Bundle;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OsgiPluginUninstalledHelper
implements OsgiPluginHelper {
    private final String key;
    private final OsgiContainerManager osgiContainerManager;
    private final PluginArtifact pluginArtifact;

    public OsgiPluginUninstalledHelper(String key, OsgiContainerManager mgr, PluginArtifact artifact) {
        Validate.notNull((Object)key);
        Validate.notNull((Object)mgr);
        Validate.notNull((Object)artifact);
        this.key = key;
        this.pluginArtifact = artifact;
        this.osgiContainerManager = mgr;
    }

    @Override
    public Bundle getBundle() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage() + " This is probably because the module " + "descriptor is trying to load classes in its init() method.  Move all classloading into the " + "enabled() method, and be sure to properly drop class and instance references in disabled().");
    }

    @Override
    public URL getResource(String name) {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public ClassLoader getClassLoader() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public Bundle install() {
        Bundle bundle = this.osgiContainerManager.installBundle(this.pluginArtifact.toFile());
        if (!OsgiHeaderUtil.getPluginKey(bundle).equals(this.key)) {
            throw new IllegalArgumentException("The plugin key '" + this.key + "' must either match the OSGi bundle symbolic " + "name (Bundle-SymbolicName) or be specified in the Atlassian-Plugin-Key manifest header");
        }
        return bundle;
    }

    @Override
    public void onEnable(ServiceTracker ... serviceTrackers) throws OsgiContainerException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public void onDisable() throws OsgiContainerException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public void onUninstall() throws OsgiContainerException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public void autowire(Object instance, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalStateException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public <T> T autowire(Class<T> clazz, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public Set<String> getRequiredPlugins() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public void setPluginContainer(Object container) {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    @Override
    public ContainerAccessor getContainerAccessor() {
        throw new IllegalPluginStateException(this.getNotInstalledMessage());
    }

    private String getNotInstalledMessage() {
        return "This operation requires the plugin '" + this.key + "' to be installed";
    }
}

