/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.external;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleModuleDescriptorFactory<T extends ModuleDescriptor<?>>
implements ListableModuleDescriptorFactory {
    private final String type;
    private final Class<T> moduleDescriptorClass;
    private final HostContainer hostContainer;

    public SingleModuleDescriptorFactory(HostContainer hostContainer, String type, Class<T> moduleDescriptorClass) {
        this.moduleDescriptorClass = moduleDescriptorClass;
        this.type = type;
        this.hostContainer = hostContainer;
    }

    public ModuleDescriptor getModuleDescriptor(String type) throws PluginParseException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        ModuleDescriptor result = null;
        if (this.type.equals(type)) {
            result = (ModuleDescriptor)this.hostContainer.create(this.moduleDescriptorClass);
        }
        return result;
    }

    public boolean hasModuleDescriptor(String type) {
        return this.type.equals(type);
    }

    public Class<? extends ModuleDescriptor<?>> getModuleDescriptorClass(String type) {
        return this.type.equals(type) ? this.moduleDescriptorClass : null;
    }

    @Override
    public Set<Class<ModuleDescriptor<?>>> getModuleDescriptorClasses() {
        return Collections.singleton(this.moduleDescriptorClass);
    }

    public HostContainer getHostContainer() {
        return this.hostContainer;
    }
}

