/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.stage;

import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.TransformContext;
import com.atlassian.plugin.osgi.factory.transform.TransformStage;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;

public class ScanDescriptorForHostClassesStage
implements TransformStage {
    private static final Log log = LogFactory.getLog(ScanDescriptorForHostClassesStage.class);

    public void execute(TransformContext context) throws PluginTransformationException {
        XPath xpath = DocumentHelper.createXPath((String)"//@class");
        List attributes = xpath.selectNodes((Object)context.getDescriptorDocument());
        for (Attribute attr : attributes) {
            String className = attr.getValue();
            int dotpos = className.lastIndexOf(".");
            if (dotpos <= -1) continue;
            String pkg = className.substring(0, dotpos);
            String pkgPath = pkg.replace('.', '/') + '/';
            if (!context.getSystemExports().isExported(pkg)) continue;
            if (context.getPluginArtifact().doesResourceExist(pkgPath)) {
                log.warn((Object)("The plugin '" + context.getPluginArtifact().toString() + "' uses a package '" + pkg + "' that is also exported by the application.  It is highly recommended that the " + "plugin use its own packages."));
                continue;
            }
            context.getExtraImports().add(pkg);
        }
    }
}

