/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.factory.OsgiPluginHelper;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.resource.AlternativeDirectoryResourceLoader;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OsgiPluginInstalledHelper
implements OsgiPluginHelper {
    private final ClassLoader bundleClassLoader;
    private final Bundle bundle;
    private final PackageAdmin packageAdmin;
    private final boolean requireSpring;
    private volatile SpringContextAccessor springContextAccessor;
    private ServiceTracker[] serviceTrackers;

    public OsgiPluginInstalledHelper(Bundle bundle, PackageAdmin packageAdmin, boolean requireSpring) {
        Validate.notNull((Object)bundle);
        Validate.notNull((Object)packageAdmin);
        this.bundle = bundle;
        this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
        this.packageAdmin = packageAdmin;
        this.requireSpring = requireSpring;
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        return BundleClassLoaderAccessor.loadClass(this.getBundle(), clazz);
    }

    @Override
    public URL getResource(String name) {
        return this.bundleClassLoader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.bundleClassLoader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.bundleClassLoader;
    }

    @Override
    public Bundle install() {
        throw new IllegalPluginStateException("Plugin '" + this.bundle.getSymbolicName() + "' has already been installed");
    }

    @Override
    public void onEnable(ServiceTracker ... serviceTrackers) throws OsgiContainerException {
        Validate.notNull((Object)serviceTrackers);
        this.serviceTrackers = serviceTrackers;
        for (ServiceTracker svc : serviceTrackers) {
            svc.open();
        }
    }

    @Override
    public void onDisable() throws OsgiContainerException {
        for (ServiceTracker svc : this.serviceTrackers) {
            svc.close();
        }
        this.serviceTrackers = null;
        this.setPluginContainer(null);
    }

    @Override
    public void onUninstall() throws OsgiContainerException {
    }

    @Override
    public <T> T autowire(Class<T> clazz, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        if (this.requireSpring) {
            this.assertSpringContextAvailable();
            return this.springContextAccessor.createBean(clazz, autowireStrategy);
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginException("Unable to instantiate " + clazz, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException("Unable to access " + clazz, (Throwable)e);
        }
    }

    @Override
    public void autowire(Object instance, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        if (this.requireSpring) {
            this.assertSpringContextAvailable();
            this.springContextAccessor.createBean(instance, autowireStrategy);
        }
    }

    @Override
    public Set<String> getRequiredPlugins() {
        HashSet<String> keys = new HashSet<String>();
        Set<String> imports = OsgiHeaderUtil.parseHeader((String)this.getBundle().getHeaders().get("Import-Package")).keySet();
        for (String imp : imports) {
            ExportedPackage[] exports = this.packageAdmin.getExportedPackages(imp);
            if (exports == null) continue;
            block1: for (ExportedPackage export : exports) {
                Bundle[] importingBundles = export.getImportingBundles();
                if (importingBundles == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (this.getBundle() != importingBundle) continue;
                    keys.add(OsgiHeaderUtil.getPluginKey(export.getExportingBundle()));
                    continue block1;
                }
            }
        }
        return keys;
    }

    @Override
    public void setPluginContainer(Object container) {
        this.springContextAccessor = container == null ? null : new SpringContextAccessor(container);
    }

    private void assertSpringContextAvailable() throws IllegalPluginStateException {
        if (this.springContextAccessor == null) {
            throw new IllegalStateException("Cannot autowire object because the Spring context is unavailable.  Ensure your OSGi bundle contains the 'Spring-Context' header.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SpringContextAccessor {
        private final Object nativeBeanFactory;
        private final Method nativeCreateBeanMethod;
        private final Method nativeAutowireBeanMethod;

        public SpringContextAccessor(Object applicationContext) {
            Object beanFactory = null;
            try {
                Method m = applicationContext.getClass().getMethod("getAutowireCapableBeanFactory", new Class[0]);
                beanFactory = m.invoke(applicationContext, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new PluginException("Cannot find createBean method on registered bean factory: " + beanFactory, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PluginException("Cannot access createBean method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.handleSpringMethodInvocationError(e);
            }
            this.nativeBeanFactory = beanFactory;
            try {
                this.nativeCreateBeanMethod = beanFactory.getClass().getMethod("createBean", Class.class, Integer.TYPE, Boolean.TYPE);
                this.nativeAutowireBeanMethod = beanFactory.getClass().getMethod("autowireBeanProperties", Object.class, Integer.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new PluginException("Cannot find createBean method on registered bean factory: " + this.nativeBeanFactory, (Throwable)e);
            }
        }

        private void handleSpringMethodInvocationError(InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new PluginException("Unable to invoke createBean", e.getCause());
        }

        public <T> T createBean(Class<T> clazz, AutowireCapablePlugin.AutowireStrategy autowireStrategy) {
            if (this.nativeBeanFactory == null) {
                return null;
            }
            try {
                return clazz.cast(this.nativeCreateBeanMethod.invoke(this.nativeBeanFactory, clazz, autowireStrategy.ordinal(), false));
            }
            catch (IllegalAccessException e) {
                throw new PluginException("Unable to access createBean method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.handleSpringMethodInvocationError(e);
                return null;
            }
        }

        public void createBean(Object instance, AutowireCapablePlugin.AutowireStrategy autowireStrategy) {
            if (this.nativeBeanFactory == null) {
                return;
            }
            try {
                this.nativeAutowireBeanMethod.invoke(this.nativeBeanFactory, instance, autowireStrategy.ordinal(), false);
            }
            catch (IllegalAccessException e) {
                throw new PluginException("Unable to access createBean method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.handleSpringMethodInvocationError(e);
            }
        }
    }
}

