/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class ModuleDescriptorServiceTrackerCustomizer
implements ServiceTrackerCustomizer {
    private static final Log log = LogFactory.getLog(ModuleDescriptorServiceTrackerCustomizer.class);
    private final Bundle bundle;
    private final OsgiPlugin plugin;

    public ModuleDescriptorServiceTrackerCustomizer(OsgiPlugin plugin) {
        Validate.notNull((Object)((Object)plugin));
        this.bundle = plugin.getBundle();
        Validate.notNull((Object)this.bundle);
        this.plugin = plugin;
    }

    public Object addingService(ServiceReference serviceReference) {
        ModuleDescriptor descriptor = null;
        if (serviceReference.getBundle() == this.bundle) {
            descriptor = (ModuleDescriptor)this.bundle.getBundleContext().getService(serviceReference);
            this.plugin.addModuleDescriptor(descriptor);
            if (log.isInfoEnabled()) {
                log.info((Object)("Dynamically registered new module descriptor: " + descriptor.getCompleteKey()));
            }
        }
        return descriptor;
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
        if (serviceReference.getBundle() == this.bundle) {
            ModuleDescriptor descriptor = (ModuleDescriptor)o;
            this.plugin.addModuleDescriptor(descriptor);
            if (log.isInfoEnabled()) {
                log.info((Object)("Dynamically upgraded new module descriptor: " + descriptor.getCompleteKey()));
            }
        }
    }

    public void removedService(ServiceReference serviceReference, Object o) {
        if (serviceReference.getBundle() == this.bundle) {
            ModuleDescriptor descriptor = (ModuleDescriptor)o;
            this.plugin.clearModuleDescriptor(descriptor.getKey());
            if (log.isInfoEnabled()) {
                log.info((Object)("Dynamically removed module descriptor: " + descriptor.getCompleteKey()));
            }
        }
    }
}

