/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.felix;

import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartingEvent;
import com.atlassian.plugin.event.events.PluginFrameworkWarmRestartingEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.felix.ExportsBuilder;
import com.atlassian.plugin.osgi.container.felix.FelixLoggerBridge;
import com.atlassian.plugin.osgi.container.impl.DefaultOsgiPersistentCache;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.hostcomponents.impl.DefaultComponentRegistrar;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugin.util.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.StringMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixOsgiContainerManager
implements OsgiContainerManager {
    public static final String OSGI_FRAMEWORK_BUNDLES_ZIP = "osgi-framework-bundles.zip";
    private static final Log log = LogFactory.getLog(FelixOsgiContainerManager.class);
    private static final String OSGI_BOOTDELEGATION = "org.osgi.framework.bootdelegation";
    private static final String ATLASSIAN_PREFIX = "atlassian.";
    private final OsgiPersistentCache persistentCache;
    private final URL frameworkBundlesUrl;
    private final PackageScannerConfiguration packageScannerConfig;
    private final HostComponentProvider hostComponentProvider;
    private final Set<ServiceTracker> trackers;
    private final ExportsBuilder exportsBuilder;
    private final ThreadFactory threadFactory = new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Felix:Startup");
            thread.setDaemon(true);
            return thread;
        }
    };
    private BundleRegistration registration = null;
    private Felix felix = null;
    private boolean felixRunning = false;
    private boolean disableMultipleBundleVersions = true;
    private Logger felixLogger;

    @Deprecated
    public FelixOsgiContainerManager(File frameworkBundlesDir, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) {
        this(ClassLoaderUtils.getResource((String)OSGI_FRAMEWORK_BUNDLES_ZIP, FelixOsgiContainerManager.class), frameworkBundlesDir, packageScannerConfig, provider, eventManager);
    }

    @Deprecated
    public FelixOsgiContainerManager(URL frameworkBundlesZip, File frameworkBundlesDir, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) {
        this(frameworkBundlesZip, new DefaultOsgiPersistentCache(new File(frameworkBundlesDir.getParentFile(), "osgi-cache")), packageScannerConfig, provider, eventManager);
    }

    public FelixOsgiContainerManager(OsgiPersistentCache persistentCache, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) {
        this(ClassLoaderUtils.getResource((String)OSGI_FRAMEWORK_BUNDLES_ZIP, FelixOsgiContainerManager.class), persistentCache, packageScannerConfig, provider, eventManager);
    }

    public FelixOsgiContainerManager(URL frameworkBundlesZip, OsgiPersistentCache persistentCache, PackageScannerConfiguration packageScannerConfig, HostComponentProvider provider, PluginEventManager eventManager) throws OsgiContainerException {
        Validate.notNull((Object)frameworkBundlesZip, (String)"The framework bundles zip is required");
        Validate.notNull((Object)persistentCache, (String)"The framework bundles directory must not be null");
        Validate.notNull((Object)packageScannerConfig, (String)"The package scanner configuration must not be null");
        Validate.notNull((Object)eventManager, (String)"The plugin event manager is required");
        this.frameworkBundlesUrl = frameworkBundlesZip;
        this.packageScannerConfig = packageScannerConfig;
        this.persistentCache = persistentCache;
        this.hostComponentProvider = provider;
        this.trackers = Collections.synchronizedSet(new HashSet());
        eventManager.register((Object)this);
        this.felixLogger = new FelixLoggerBridge(log);
        this.exportsBuilder = new ExportsBuilder();
    }

    public void setFelixLogger(Logger logger) {
        this.felixLogger = logger;
    }

    public void setDisableMultipleBundleVersions(boolean val) {
        this.disableMultipleBundleVersions = val;
    }

    @PluginEventListener
    public void onStart(PluginFrameworkStartingEvent event) {
        this.start();
    }

    @PluginEventListener
    public void onShutdown(PluginFrameworkShutdownEvent event) {
        this.stop();
    }

    @PluginEventListener
    public void onPluginUpgrade(PluginUpgradedEvent event) {
        this.registration.refreshPackages();
    }

    @PluginEventListener
    public void onPluginFrameworkWarmRestarting(PluginFrameworkWarmRestartingEvent event) {
        this.registration.loadHostComponents(this.collectHostComponents(this.hostComponentProvider));
    }

    @Override
    public void start() throws OsgiContainerException {
        if (this.isRunning()) {
            return;
        }
        DefaultComponentRegistrar registrar = this.collectHostComponents(this.hostComponentProvider);
        StringMap configMap = new StringMap(false);
        configMap.put((Object)"felix.embedded.execution", (Object)"true");
        configMap.put((Object)"org.osgi.framework.system.packages", (Object)this.exportsBuilder.determineExports(registrar.getRegistry(), this.packageScannerConfig, this.persistentCache.getOsgiBundleCache()));
        configMap.put((Object)"felix.cache.profiledir", (Object)this.persistentCache.getOsgiBundleCache().getAbsolutePath());
        configMap.put((Object)"felix.log.level", (Object)String.valueOf(this.felixLogger.getLogLevel()));
        String bootDelegation = this.getAtlassianSpecificOsgiSystemProperty(OSGI_BOOTDELEGATION);
        if (bootDelegation == null || bootDelegation.trim().length() == 0) {
            bootDelegation = "weblogic.*,META-INF.services,com.yourkit.*,com.jprofiler.*,org.apache.xerces.*";
        }
        configMap.put((Object)OSGI_BOOTDELEGATION, (Object)bootDelegation);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Felix configuration: " + configMap));
        }
        this.validateConfiguration(configMap);
        try {
            this.registration = new BundleRegistration(this.frameworkBundlesUrl, this.persistentCache.getFrameworkBundleCache(), registrar);
            ArrayList<BundleRegistration> list = new ArrayList<BundleRegistration>();
            list.add(this.registration);
            this.felix = new Felix(this.felixLogger, (Map)configMap, list);
            Runnable start = new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader(null);
                        FelixOsgiContainerManager.this.felix.start();
                        FelixOsgiContainerManager.this.felixRunning = true;
                    }
                    catch (BundleException e) {
                        throw new OsgiContainerException("Unable to start felix", e);
                    }
                }
            };
            Thread t = this.threadFactory.newThread(start);
            t.start();
            t.join(600000L);
        }
        catch (Exception ex) {
            throw new OsgiContainerException("Unable to start OSGi container", ex);
        }
    }

    private void validateConfiguration(StringMap configMap) throws OsgiContainerException {
        String systemExports = (String)configMap.get((Object)"org.osgi.framework.system.packages");
        this.validateCaches(systemExports);
        this.detectIncorrectOsgiVersion();
        this.detectXercesOverride(systemExports);
    }

    void detectXercesOverride(String systemExports) throws OsgiContainerException {
        int pos = systemExports.indexOf("org.apache.xerces.util");
        if (pos > -1 && ((pos += "org.apache.xerces.util".length()) >= systemExports.length() || ';' != systemExports.charAt(pos))) {
            throw new OsgiContainerException("Detected an incompatible version of Apache Xerces on the classpath.  If using Tomcat, you may have an old version of Xerces in $TOMCAT_HOME/common/lib/endorsed that will need to be removed.");
        }
    }

    private void validateCaches(String systemExports) {
        String cacheKey = String.valueOf(systemExports.hashCode());
        this.persistentCache.validate(cacheKey);
        log.debug((Object)("Using Felix bundle cache directory :" + this.persistentCache.getOsgiBundleCache().getAbsolutePath()));
    }

    private void detectIncorrectOsgiVersion() {
        try {
            Bundle.class.getMethod("getBundleContext", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new OsgiContainerException("Detected older version (4.0 or earlier) of OSGi.  If using WebSphere 6.1, please enable application-first (parent-last) classloading and the 'Single classloader for application' WAR classloader policy.");
        }
    }

    @Override
    public void stop() throws OsgiContainerException {
        if (this.felixRunning) {
            for (ServiceTracker tracker : new HashSet<ServiceTracker>(this.trackers)) {
                tracker.close();
            }
            this.felix.stopAndWait();
        }
        this.felixRunning = false;
        this.felix = null;
    }

    @Override
    public Bundle[] getBundles() {
        if (this.isRunning()) {
            return this.registration.getBundles();
        }
        throw new IllegalStateException("Cannot retrieve the bundles if the Felix container isn't running. Check earlier in the logs for the possible cause as to why Felix didn't start correctly.");
    }

    @Override
    public ServiceReference[] getRegisteredServices() {
        return this.felix.getRegisteredServices();
    }

    @Override
    public ServiceTracker getServiceTracker(String cls) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Unable to create a tracker when osgi is not running");
        }
        ServiceTracker tracker = this.registration.getServiceTracker(cls, this.trackers);
        tracker.open();
        this.trackers.add(tracker);
        return tracker;
    }

    @Override
    public Bundle installBundle(File file) throws OsgiContainerException {
        try {
            return this.registration.install(file, this.disableMultipleBundleVersions);
        }
        catch (BundleException e) {
            throw new OsgiContainerException("Unable to install bundle", e);
        }
    }

    DefaultComponentRegistrar collectHostComponents(HostComponentProvider provider) {
        DefaultComponentRegistrar registrar = new DefaultComponentRegistrar();
        if (provider != null) {
            provider.provide(registrar);
        }
        return registrar;
    }

    @Override
    public boolean isRunning() {
        return this.felixRunning;
    }

    @Override
    public List<HostComponentRegistration> getHostComponentRegistrations() {
        return this.registration.getHostComponentRegistrations();
    }

    private String getAtlassianSpecificOsgiSystemProperty(String originalSystemProperty) {
        return System.getProperty(ATLASSIAN_PREFIX + originalSystemProperty);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BundleRegistration
    implements BundleActivator,
    BundleListener,
    FrameworkListener {
        private BundleContext bundleContext;
        private DefaultComponentRegistrar registrar;
        private List<ServiceRegistration> hostServicesReferences;
        private List<HostComponentRegistration> hostComponentRegistrations;
        private final URL frameworkBundlesUrl;
        private final File frameworkBundlesDir;
        private final ClassLoader initializedClassLoader;
        private PackageAdmin packageAdmin;

        public BundleRegistration(URL frameworkBundlesUrl, File frameworkBundlesDir, DefaultComponentRegistrar registrar) {
            this.registrar = registrar;
            this.frameworkBundlesUrl = frameworkBundlesUrl;
            this.frameworkBundlesDir = frameworkBundlesDir;
            this.initializedClassLoader = Thread.currentThread().getContextClassLoader();
        }

        public void start(BundleContext context) throws Exception {
            this.bundleContext = context;
            ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
            this.packageAdmin = (PackageAdmin)context.getService(ref);
            context.addBundleListener((BundleListener)this);
            context.addFrameworkListener((FrameworkListener)this);
            this.loadHostComponents(this.registrar);
            this.extractAndInstallFrameworkBundles();
        }

        public void stop(BundleContext ctx) throws Exception {
            ctx.removeBundleListener((BundleListener)this);
            ctx.removeFrameworkListener((FrameworkListener)this);
            if (this.hostServicesReferences != null) {
                for (ServiceRegistration ref : this.hostServicesReferences) {
                    ref.unregister();
                }
            }
            this.bundleContext = null;
            this.packageAdmin = null;
            this.hostServicesReferences = null;
            this.hostComponentRegistrations = null;
            this.registrar = null;
        }

        public void bundleChanged(BundleEvent evt) {
            switch (evt.getType()) {
                case 1: {
                    log.info((Object)("Installed bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")"));
                    break;
                }
                case 32: {
                    log.info((Object)("Resolved bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")"));
                    break;
                }
                case 64: {
                    log.info((Object)("Unresolved bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")"));
                    break;
                }
                case 2: {
                    log.info((Object)("Started bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")"));
                    break;
                }
                case 4: {
                    log.info((Object)("Stopped bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")"));
                    break;
                }
                case 16: {
                    log.info((Object)("Uninstalled bundle " + evt.getBundle().getSymbolicName() + " (" + evt.getBundle().getBundleId() + ")"));
                }
            }
        }

        public Bundle install(File path, boolean uninstallOtherVersions) throws BundleException {
            boolean bundleUninstalled = false;
            if (uninstallOtherVersions) {
                try {
                    JarFile jar = new JarFile(path);
                    String pluginKey = OsgiHeaderUtil.getPluginKey(jar.getManifest());
                    for (Bundle oldBundle : this.bundleContext.getBundles()) {
                        if (!pluginKey.equals(OsgiHeaderUtil.getPluginKey(oldBundle))) continue;
                        log.info((Object)("Uninstalling existing version " + oldBundle.getHeaders().get("Bundle-Version")));
                        oldBundle.uninstall();
                        bundleUninstalled = true;
                    }
                }
                catch (IOException e) {
                    throw new BundleException("Invalid bundle format", (Throwable)e);
                }
            }
            Bundle bundle = this.bundleContext.installBundle(path.toURI().toString());
            if (bundleUninstalled) {
                this.refreshPackages();
            }
            return bundle;
        }

        public Bundle[] getBundles() {
            return this.bundleContext.getBundles();
        }

        public ServiceTracker getServiceTracker(String clazz, final Set<ServiceTracker> trackedTrackers) {
            return new ServiceTracker(this.bundleContext, clazz, null){

                public void close() {
                    trackedTrackers.remove((Object)this);
                }
            };
        }

        public List<HostComponentRegistration> getHostComponentRegistrations() {
            return this.hostComponentRegistrations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadHostComponents(DefaultComponentRegistrar registrar) {
            if (this.hostServicesReferences != null) {
                for (ServiceRegistration reg : this.hostServicesReferences) {
                    reg.unregister();
                }
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.initializedClassLoader);
                this.hostServicesReferences = registrar.writeRegistry(this.bundleContext);
                this.hostComponentRegistrations = registrar.getRegistry();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        private void extractAndInstallFrameworkBundles() throws BundleException {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            FileUtils.conditionallyExtractZipFile((URL)this.frameworkBundlesUrl, (File)this.frameworkBundlesDir);
            for (File bundleFile : this.frameworkBundlesDir.listFiles(new FilenameFilter(){

                public boolean accept(File file, String s) {
                    return s.endsWith(".jar");
                }
            })) {
                bundles.add(this.install(bundleFile, false));
            }
            for (Bundle bundle : bundles) {
                bundle.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshPackages() {
            final CountDownLatch latch = new CountDownLatch(1);
            FrameworkListener refreshListener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 4) {
                        log.info((Object)"Packages refreshed");
                        latch.countDown();
                    }
                }
            };
            this.bundleContext.addFrameworkListener(refreshListener);
            try {
                this.packageAdmin.refreshPackages(null);
                boolean refreshed = false;
                try {
                    refreshed = latch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!refreshed) {
                    log.warn((Object)"Timeout exceeded waiting for package refresh");
                }
            }
            finally {
                this.bundleContext.removeFrameworkListener(refreshListener);
            }
        }

        public void frameworkEvent(FrameworkEvent event) {
            String bundleBits = "";
            if (event.getBundle() != null) {
                bundleBits = " in bundle " + event.getBundle().getSymbolicName();
            }
            switch (event.getType()) {
                case 2: {
                    log.error((Object)("Framework error" + bundleBits), event.getThrowable());
                    break;
                }
                case 16: {
                    log.warn((Object)("Framework warning" + bundleBits), event.getThrowable());
                    break;
                }
                case 32: {
                    log.info((Object)("Framework info" + bundleBits), event.getThrowable());
                }
            }
        }
    }
}

