/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform;

import com.atlassian.plugin.util.collect.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class JarUtils {
    private JarUtils() {
    }

    static Manifest getManifest(File file) {
        Manifest result = JarUtils.withJar(file, ManifestExtractor.INSTANCE);
        return result == null ? new Manifest() : result;
    }

    static Iterable<JarEntry> getEntries(File file) {
        return JarUtils.withJar(file, JarEntryExtractor.INSTANCE);
    }

    static JarEntry getEntry(File file, final String path) {
        return JarUtils.withJar(file, new Extractor<JarEntry>(){

            public JarEntry get(JarFile jarFile) {
                return jarFile.getJarEntry(path);
            }
        });
    }

    public static <T> T withJar(File file, Extractor<T> extractor) {
        Object object;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            object = extractor.get(jarFile);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("File must be a jar: " + file, e);
            }
            catch (Throwable throwable) {
                JarUtils.closeQuietly(jarFile);
                throw throwable;
            }
        }
        JarUtils.closeQuietly(jarFile);
        return (T)object;
    }

    public static void closeQuietly(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static enum JarEntryExtractor implements Extractor<Iterable<JarEntry>>
    {
        INSTANCE;


        public Iterable<JarEntry> get(JarFile jarFile) {
            return ImmutableList.copyOf((Iterator)Iterators.forEnumeration(jarFile.entries()));
        }
    }

    static enum ManifestExtractor implements Extractor<Manifest>
    {
        INSTANCE;


        public Manifest get(JarFile input) {
            try {
                return input.getManifest();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Extractor<T>
    extends Function<JarFile, T> {
    }
}

