/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.util;

import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Resource;
import aQute.libg.header.OSGiHeader;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.util.ClassBinaryScanner;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugin.util.ClassUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiHeaderUtil {
    static Logger log = LoggerFactory.getLogger(OsgiHeaderUtil.class);
    private static final String EMPTY_OSGI_VERSION = Version.emptyVersion.toString();
    private static final Predicate<String> JAVA_PACKAGE_FILTER = new Predicate<String>(){

        public boolean apply(String pkg) {
            return !pkg.startsWith("java.");
        }
    };
    private static final Predicate<String> JAVA_CLASS_FILTER = new Predicate<String>(){

        public boolean apply(String classEntry) {
            return !classEntry.startsWith("java/");
        }
    };

    public static Set<String> findReferredPackageNames(List<HostComponentRegistration> registrations) throws IOException {
        return OsgiHeaderUtil.findReferredPackagesInternal(registrations);
    }

    public static Map<String, String> findReferredPackageVersions(List<HostComponentRegistration> registrations, Map<String, String> packageVersions) throws IOException {
        Set<String> referredPackages = OsgiHeaderUtil.findReferredPackagesInternal(registrations);
        return OsgiHeaderUtil.matchPackageVersions(referredPackages, packageVersions);
    }

    @Deprecated
    public static String findReferredPackages(List<HostComponentRegistration> registrations) throws IOException {
        return OsgiHeaderUtil.findReferredPackages(registrations, Collections.<String, String>emptyMap());
    }

    @Deprecated
    public static String findReferredPackages(List<HostComponentRegistration> registrations, Map<String, String> packageVersions) throws IOException {
        StringBuffer sb = new StringBuffer();
        HashSet<String> referredPackages = new HashSet<String>();
        HashSet<String> referredClasses = new HashSet<String>();
        if (registrations == null) {
            sb.append(",");
        } else {
            for (HostComponentRegistration reg : registrations) {
                HashSet classesToScan = new HashSet();
                for (Class<?> inf : reg.getMainInterfaceClasses()) {
                    ClassUtils.findAllTypes(inf, classesToScan);
                }
                for (Class inf : classesToScan) {
                    String clsName = inf.getName().replace('.', '/') + ".class";
                    OsgiHeaderUtil.crawlReferenceTree(clsName, referredClasses, referredPackages, 1);
                }
            }
            for (String pkg : referredPackages) {
                String version = packageVersions.get(pkg);
                sb.append(pkg);
                if (version != null) {
                    try {
                        Version.parseVersion((String)version);
                        sb.append(";version=").append(version);
                    }
                    catch (IllegalArgumentException ex) {
                        log.info("Unable to parse version: " + version);
                    }
                }
                sb.append(",");
            }
        }
        return sb.toString();
    }

    static Map<String, String> matchPackageVersions(Set<String> packageNames, Map<String, String> packageVersions) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (String pkg : packageNames) {
            String version = packageVersions.get(pkg);
            String effectiveKey = pkg;
            String effectiveValue = EMPTY_OSGI_VERSION;
            if (version != null) {
                try {
                    Version.parseVersion((String)version);
                    effectiveValue = version;
                }
                catch (IllegalArgumentException ex) {
                    log.info("Unable to parse version: " + version);
                }
            }
            output.put(effectiveKey, effectiveValue);
        }
        return ImmutableMap.copyOf(output);
    }

    static Set<String> findReferredPackagesInternal(List<HostComponentRegistration> registrations) throws IOException {
        HashSet<String> referredPackages = new HashSet<String>();
        HashSet<String> referredClasses = new HashSet<String>();
        if (registrations != null) {
            for (HostComponentRegistration reg : registrations) {
                HashSet classesToScan = new HashSet();
                for (Class<?> inf : reg.getMainInterfaceClasses()) {
                    ClassUtils.findAllTypes(inf, classesToScan);
                }
                for (Class inf : classesToScan) {
                    String clsName = inf.getName().replace('.', '/') + ".class";
                    OsgiHeaderUtil.crawlReferenceTree(clsName, referredClasses, referredPackages, 1);
                }
            }
        }
        return ImmutableSet.copyOf(referredPackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void crawlReferenceTree(String className, Set<String> scannedClasses, Set<String> packageImports, int level) throws IOException {
        if (level <= 0) {
            return;
        }
        if (className.startsWith("java/")) {
            return;
        }
        if (scannedClasses.contains(className)) {
            return;
        }
        scannedClasses.add(className);
        if (log.isDebugEnabled()) {
            log.debug("Crawling " + className);
        }
        ClassBinaryScanner.InputStreamResource classBinaryResource = null;
        try {
            InputStream in = ClassLoaderUtils.getResourceAsStream((String)className, OsgiHeaderUtil.class);
            if (in == null) {
                log.error("Cannot find class: [" + className + "]");
                return;
            }
            classBinaryResource = new ClassBinaryScanner.InputStreamResource(in);
            ClassBinaryScanner.ScanResult scanResult = ClassBinaryScanner.scanClassBinary(new Clazz(className, (Resource)classBinaryResource));
            packageImports.addAll(Sets.filter(scanResult.getReferredPackages(), JAVA_PACKAGE_FILTER));
            Set referredClasses = Sets.filter(scanResult.getReferredClasses(), JAVA_CLASS_FILTER);
            for (String ref : referredClasses) {
                OsgiHeaderUtil.crawlReferenceTree(ref + ".class", scannedClasses, packageImports, level - 1);
            }
        }
        finally {
            if (classBinaryResource != null) {
                classBinaryResource.close();
            }
        }
    }

    public static Map<String, Map<String, String>> parseHeader(String header) {
        return OSGiHeader.parseHeader((String)header);
    }

    public static String buildHeader(Map<String, Map<String, String>> values) {
        StringBuilder header = new StringBuilder();
        Iterator<Map.Entry<String, Map<String, String>>> i = values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = i.next();
            OsgiHeaderUtil.buildHeader(entry.getKey(), entry.getValue(), header);
            if (!i.hasNext()) continue;
            header.append(",");
        }
        return header.toString();
    }

    public static String buildHeader(String key, Map<String, String> attrs) {
        StringBuilder fullPkg = new StringBuilder();
        OsgiHeaderUtil.buildHeader(key, attrs, fullPkg);
        return fullPkg.toString();
    }

    private static void buildHeader(String key, Map<String, String> attrs, StringBuilder builder) {
        builder.append(key);
        if (attrs != null && !attrs.isEmpty()) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                builder.append(";");
                builder.append(entry.getKey());
                builder.append("=\"");
                builder.append(entry.getValue());
                builder.append("\"");
            }
        }
    }

    public static String getPluginKey(Bundle bundle) {
        return OsgiHeaderUtil.getPluginKey(bundle.getSymbolicName(), bundle.getHeaders().get("Atlassian-Plugin-Key"), bundle.getHeaders().get("Bundle-Version"));
    }

    public static String getPluginKey(Manifest mf) {
        return OsgiHeaderUtil.getPluginKey(mf.getMainAttributes().getValue("Bundle-SymbolicName"), mf.getMainAttributes().getValue("Atlassian-Plugin-Key"), mf.getMainAttributes().getValue("Bundle-Version"));
    }

    private static String getPluginKey(Object bundleName, Object atlKey, Object version) {
        Object key = atlKey;
        if (key == null) {
            key = bundleName + "-" + version;
        }
        return key.toString();
    }

    public static String generatePackageVersionString(Map<String, String> packages) {
        if (packages == null || packages.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> packageNames = new ArrayList<String>(packages.keySet());
        Collections.sort(packageNames);
        for (String packageName : packageNames) {
            sb.append(",");
            sb.append(packageName);
            String version = packages.get(packageName);
            if (version == null || version.equals(EMPTY_OSGI_VERSION)) continue;
            sb.append(";version=").append(version);
        }
        sb.delete(0, 1);
        return sb.toString();
    }
}

