/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformer;
import com.atlassian.plugin.osgi.factory.transform.TransformContext;
import com.atlassian.plugin.osgi.factory.transform.TransformStage;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.osgi.factory.transform.stage.AddBundleOverridesStage;
import com.atlassian.plugin.osgi.factory.transform.stage.ComponentImportSpringStage;
import com.atlassian.plugin.osgi.factory.transform.stage.ComponentSpringStage;
import com.atlassian.plugin.osgi.factory.transform.stage.GenerateManifestStage;
import com.atlassian.plugin.osgi.factory.transform.stage.HostComponentSpringStage;
import com.atlassian.plugin.osgi.factory.transform.stage.ModuleTypeSpringStage;
import com.atlassian.plugin.osgi.factory.transform.stage.ScanDescriptorForHostClassesStage;
import com.atlassian.plugin.osgi.factory.transform.stage.ScanInnerJarsStage;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.util.PluginUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginTransformer
implements PluginTransformer {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginTransformer.class);
    private final String pluginDescriptorPath;
    private final List<TransformStage> stages;
    private final File bundleCacheDir;
    private final SystemExports systemExports;
    private final Set<String> applicationKeys;
    private final OsgiPersistentCache osgiCache;
    private final OsgiContainerManager osgiContainerManager;

    public static ArrayList<TransformStage> getDefaultTransformStages() {
        return new ArrayList<TransformStage>(Arrays.asList(new AddBundleOverridesStage(), new ScanInnerJarsStage(), new ComponentImportSpringStage(), new ComponentSpringStage(), new ScanDescriptorForHostClassesStage(), new ModuleTypeSpringStage(), new HostComponentSpringStage(), new GenerateManifestStage()));
    }

    public DefaultPluginTransformer(OsgiPersistentCache cache, SystemExports systemExports, Set<String> applicationKeys, String pluginDescriptorPath, OsgiContainerManager osgiContainerManager) {
        this(cache, systemExports, applicationKeys, pluginDescriptorPath, osgiContainerManager, DefaultPluginTransformer.getDefaultTransformStages());
    }

    public DefaultPluginTransformer(OsgiPersistentCache cache, SystemExports systemExports, Set<String> applicationKeys, String pluginDescriptorPath, OsgiContainerManager osgiContainerManager, List<TransformStage> stages) {
        Validate.notNull((Object)pluginDescriptorPath, (String)"The plugin descriptor path is required");
        Validate.notNull(stages, (String)"A list of stages is required");
        this.osgiContainerManager = osgiContainerManager;
        this.pluginDescriptorPath = pluginDescriptorPath;
        this.stages = Collections.unmodifiableList(new ArrayList<TransformStage>(stages));
        this.osgiCache = cache;
        this.bundleCacheDir = cache.getTransformedPluginCache();
        this.systemExports = systemExports;
        this.applicationKeys = applicationKeys;
        this.persistTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistTimeout() {
        block14: {
            File timeoutFile = new File(this.bundleCacheDir.getAbsoluteFile().getParentFile(), ".properties");
            String timeout = System.getProperty("atlassian.plugins.enable.wait");
            if (timeout == null && !timeoutFile.exists()) {
                return;
            }
            Properties properties = new Properties();
            Integer currentTimeout = null;
            try {
                Integer newTimeout = PluginUtils.getDefaultEnablingWaitPeriod();
                if (timeoutFile.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(timeoutFile);
                    properties.load(fileInputStream);
                    currentTimeout = Integer.parseInt(properties.getProperty("spring.timeout"));
                }
                if (!newTimeout.equals(currentTimeout)) {
                    this.osgiCache.clear();
                }
                if (timeout != null) {
                    FileOutputStream fileOutputStream = null;
                    try {
                        properties.setProperty("spring.timeout", timeout);
                        fileOutputStream = new FileOutputStream(timeoutFile);
                        properties.store(fileOutputStream, null);
                        break block14;
                    }
                    finally {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException ignore) {}
                        }
                    }
                }
                timeoutFile.delete();
            }
            catch (Exception e) {
                log.warn("Failed to set spring timeout using system property 'atlassian.plugins.enable.wait' .", (Throwable)e);
            }
        }
    }

    public File transform(File pluginJar, List<HostComponentRegistration> regs) throws PluginTransformationException {
        return this.transform((PluginArtifact)new JarPluginArtifact(pluginJar), regs);
    }

    @Override
    public File transform(PluginArtifact pluginArtifact, List<HostComponentRegistration> regs) throws PluginTransformationException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact is required");
        Validate.notNull(regs, (String)"The host component registrations are required");
        File artifactFile = pluginArtifact.toFile();
        File cachedPlugin = this.getFromCache(artifactFile);
        if (cachedPlugin != null) {
            return cachedPlugin;
        }
        TransformContext context = new TransformContext(regs, this.systemExports, pluginArtifact, this.applicationKeys, this.pluginDescriptorPath, this.osgiContainerManager);
        for (TransformStage stage : this.stages) {
            stage.execute(context);
        }
        try {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Overriding files in ").append(pluginArtifact.toString()).append(":\n");
                for (Map.Entry<String, byte[]> entry : context.getFileOverrides().entrySet()) {
                    sb.append("==").append(entry.getKey()).append("==\n");
                    sb.append(new String(entry.getValue()));
                }
                log.debug(sb.toString());
            }
            return this.addFilesToExistingZip(artifactFile, context.getFileOverrides());
        }
        catch (IOException e) {
            throw new PluginTransformationException("Unable to add files to plugin jar");
        }
    }

    private File getFromCache(File artifact) {
        String name = DefaultPluginTransformer.generateCacheName(artifact);
        for (File child : this.bundleCacheDir.listFiles()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    static String generateCacheName(File file) {
        int dotPos = file.getName().lastIndexOf(46);
        if (dotPos > 0 && file.getName().length() - 1 > dotPos) {
            return file.getName().substring(0, dotPos) + "_" + file.lastModified() + file.getName().substring(dotPos);
        }
        return file.getName() + "_" + file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File addFilesToExistingZip(File zipFile, Map<String, byte[]> files) throws IOException {
        File tempFile = new File(this.bundleCacheDir, DefaultPluginTransformer.generateCacheName(zipFile));
        ZipInputStream zin = null;
        ZipOutputStream out = null;
        try {
            zin = new ZipInputStream(new FileInputStream(zipFile));
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
            out.setLevel(0);
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!files.containsKey(name)) {
                    out.putNextEntry(new ZipEntry(name));
                    IOUtils.copyLarge((InputStream)zin, (OutputStream)out);
                }
                entry = zin.getNextEntry();
            }
            zin.close();
            for (Map.Entry<String, byte[]> fentry : files.entrySet()) {
                ByteArrayInputStream in = null;
                try {
                    in = new ByteArrayInputStream(fentry.getValue());
                    out.putNextEntry(new ZipEntry(fentry.getKey()));
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                    out.closeEntry();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            out.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zin);
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)zin);
        IOUtils.closeQuietly((OutputStream)out);
        return tempFile;
    }
}

