/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.util;

import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Resource;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ClassBinaryScanner {
    public static ScanResult scanClassBinary(Clazz clazz) throws IOException {
        final ImmutableSet.Builder allReferredClasses = new ImmutableSet.Builder();
        final String[] superClassName = new String[]{null};
        try {
            clazz.parseClassFileWithCollector(new ClassDataCollector(){

                public void extendsClass(String name) {
                    superClassName[0] = name;
                    allReferredClasses.add((Object)name);
                }

                public void implementsInterfaces(String[] names) {
                    for (String name : names) {
                        allReferredClasses.add((Object)name);
                    }
                }

                public void addReference(String name) {
                    allReferredClasses.add((Object)StringUtils.replace((String)name, (String)".", (String)"/"));
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Error parsing class file", e);
        }
        return new ScanResult((Set<String>)allReferredClasses.build(), (Set<String>)ImmutableSet.copyOf((Iterable)clazz.getReferred()), superClassName[0]);
    }

    public static class InputStreamResource
    implements Resource {
        private String extra;
        private InputStream inputStream;

        public InputStreamResource(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public InputStream openInputStream() throws Exception {
            return this.inputStream;
        }

        public void write(OutputStream out) throws Exception {
            throw new UnsupportedOperationException("Not for write");
        }

        public long lastModified() {
            return -1L;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public String getExtra() {
            return this.extra;
        }

        public void close() {
            IOUtils.closeQuietly((InputStream)this.inputStream);
        }
    }

    public static class ScanResult {
        private Set<String> referredClasses;
        private Set<String> referredPackages;
        private String superClass;

        public ScanResult(Set<String> referredClasses, Set<String> referredPackages, String superClass) {
            this.referredClasses = referredClasses;
            this.referredPackages = referredPackages;
            this.superClass = superClass;
        }

        public Set<String> getReferredClasses() {
            return this.referredClasses;
        }

        public Set<String> getReferredPackages() {
            return this.referredPackages;
        }

        public String getSuperClass() {
            return this.superClass;
        }
    }
}

