/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test;

import com.atlassian.plugins.osgi.test.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiTestClassLoader {
    private static final String SERVICE_PROP_KEY = "inProductTest";
    private final BundleContext ctx;

    public OsgiTestClassLoader(BundleContext ctx) {
        this.ctx = ctx;
    }

    public Pair<String, Object> findTestInstance(String testClassname) {
        Object rawTest = null;
        String bundleSymbolicName = "unknown";
        ServiceReference ref = this.ctx.getServiceReference(testClassname);
        if (null != ref) {
            rawTest = this.ctx.getService(ref);
            bundleSymbolicName = ref.getBundle().getSymbolicName();
        }
        return Pair.pair(bundleSymbolicName, rawTest);
    }

    public Map<Bundle, List<Object>> findAllTests() {
        HashMap<Bundle, List<Object>> testMap = new HashMap<Bundle, List<Object>>();
        StringBuilder sb = new StringBuilder("(");
        sb.append(SERVICE_PROP_KEY).append("=true)");
        try {
            ServiceReference[] refs = this.ctx.getAllServiceReferences(null, sb.toString());
            if (null != refs) {
                for (ServiceReference ref : refs) {
                    Bundle bundle = ref.getBundle();
                    if (!testMap.containsKey(bundle)) {
                        testMap.put(bundle, new ArrayList());
                    }
                    testMap.get(bundle).add(this.ctx.getService(ref));
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return testMap;
    }

    public Set<Bundle> findAllBundles() {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        StringBuilder sb = new StringBuilder("(");
        sb.append(SERVICE_PROP_KEY).append("=true)");
        try {
            ServiceReference[] refs = this.ctx.getAllServiceReferences(null, sb.toString());
            if (null != refs) {
                for (ServiceReference ref : refs) {
                    bundles.add(ref.getBundle());
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return bundles;
    }

    public List<Object> findAllTestsForBundle(String bundleSymbolicName) {
        ArrayList<Object> tests = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder("(&(");
        sb.append("Bundle-SymbolicName").append("=").append(bundleSymbolicName).append(")(").append(SERVICE_PROP_KEY).append("=true))");
        try {
            ServiceReference[] refs = this.ctx.getAllServiceReferences(null, sb.toString());
            if (null != refs) {
                for (ServiceReference ref : refs) {
                    tests.add(this.ctx.getService(ref));
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return tests;
    }
}

