/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test;

import com.atlassian.plugins.osgi.test.JunitOSGiRunListener;
import java.util.List;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnitOSGiTestExecutor
extends BlockJUnit4ClassRunner {
    private Object testInstance;
    private JunitOSGiRunListener osgiListener;

    public JUnitOSGiTestExecutor(Class<?> klass, Object testInstance) throws InitializationError {
        super(klass);
        this.testInstance = testInstance;
    }

    public void run(RunNotifier notifier) {
        this.osgiListener = new JunitOSGiRunListener(notifier);
        notifier.addListener((RunListener)this.osgiListener);
        super.run(notifier);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Statement statement = this.methodInvoker(method, this.testInstance);
        statement = this.possiblyExpectingExceptions(method, this.testInstance, statement);
        statement = this.withPotentialTimeout(method, this.testInstance, statement);
        statement = this.withBefores(method, this.testInstance, statement);
        statement = this.withAfters(method, this.testInstance, statement);
        statement = this.withRules(method, this.testInstance, statement);
        return statement;
    }

    protected void validateConstructor(List<Throwable> errors) {
    }

    protected Statement withBeforeClasses(Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(BeforeClass.class);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, this.testInstance);
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, this.testInstance);
    }

    private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
        Statement result = statement;
        result = this.withMethodRules(method, target, result);
        result = this.withTestRules(method, target, result);
        return result;
    }

    private Statement withTestRules(FrameworkMethod method, Object target, Statement statement) {
        List testRules = this.getTestRules(target);
        return testRules.isEmpty() ? statement : new RunRules(statement, (Iterable)testRules, this.describeChild(method));
    }

    private Statement withMethodRules(FrameworkMethod method, Object target, Statement result) {
        List testRules = this.getTestRules(target);
        for (MethodRule each : this.getMethodRules(target)) {
            if (testRules.contains(each)) continue;
            result = each.apply(result, method, target);
        }
        return result;
    }

    private List<MethodRule> getMethodRules(Object target) {
        return this.rules(target);
    }

    public Set<String> getPassedMethodNames() {
        return this.osgiListener.getPassedMethodNames();
    }

    public Set<String> getFailedMethodNames() {
        return this.osgiListener.getFailedMethodNames();
    }

    public Set<String> getIgnoredMethodNames() {
        return this.osgiListener.getIgnoredMethodNames();
    }
}

