/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test;

import com.atlassian.plugins.osgi.test.BundleTestClassesManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class BundleTestClassesActivator
implements BundleActivator {
    private BundleListener bundleListener;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                switch (event.getType()) {
                    case 32: {
                        BundleTestClassesActivator.this.addBundle(event.getBundle());
                        break;
                    }
                    case 128: {
                        BundleTestClassesActivator.this.addBundle(event.getBundle());
                        break;
                    }
                    case 2: {
                        BundleTestClassesActivator.this.addBundle(event.getBundle());
                        break;
                    }
                    case 16: {
                        BundleTestClassesActivator.this.removeBundle(event.getBundle());
                        break;
                    }
                    case 4: {
                        BundleTestClassesActivator.this.removeBundle(event.getBundle());
                    }
                }
            }
        };
        bundleContext.addBundleListener(this.bundleListener);
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 32 && bundle.getState() != 4) continue;
            this.addBundle(bundle);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 32 && bundle.getState() != 4) continue;
            this.removeBundle(bundle);
        }
        if (this.bundleListener != null) {
            bundleContext.removeBundleListener(this.bundleListener);
        }
    }

    private void addBundle(Bundle bundle) {
        if (bundle.getSymbolicName().endsWith("-tests")) {
            BundleTestClassesManager.instance().registerBundle(bundle);
        }
    }

    private void removeBundle(Bundle bundle) {
        if (bundle.getSymbolicName().endsWith("-tests")) {
            BundleTestClassesManager.instance().unRegisterBundle(bundle);
        }
    }
}

