/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test.asm;

import com.atlassian.plugins.osgi.test.AtlassianPluginsTestRunner;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.osgi.framework.Bundle;

public class BundleClassVisitor
extends EmptyVisitor {
    private final Bundle bundle;
    private boolean isWiredTest;
    private boolean isTestClass;
    private boolean inITPackage;
    private Set<Class<?>> unitTests;
    private Set<Class<?>> itTests;
    private String normalClassName;
    private URL myUrl;
    private URL[] allUrls;

    public BundleClassVisitor(Bundle bundle, URL url, URL[] urls, Set<Class<?>> unitTests, Set<Class<?>> itTests) {
        this.bundle = bundle;
        this.unitTests = unitTests;
        this.itTests = itTests;
        this.myUrl = url;
        this.allUrls = urls;
        this.isWiredTest = false;
        this.isTestClass = false;
        this.inITPackage = false;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.normalClassName = BundleClassVisitor.normalize(name);
        if (this.normalClassName.startsWith("it.")) {
            this.inITPackage = true;
        }
        this.isTestClass = BundleClassVisitor.normalize(superName).equals(TestCase.class.getName());
        if (!this.isTestClass) {
            this.isTestClass = this.isSublassOf(superName, TestCase.class.getName());
        }
    }

    public void visitEnd() {
        if (!this.isWiredTest && this.isTestClass) {
            try {
                Class theClass = this.bundle.loadClass(this.normalClassName);
                if (this.inITPackage) {
                    this.itTests.add(theClass);
                } else {
                    this.unitTests.add(theClass);
                }
            }
            catch (Throwable t) {
                System.err.println("Error loading class from bundle: " + this.bundle.getSymbolicName() + " class: " + this.normalClassName);
                System.err.println("is it in a split package?");
            }
        }
    }

    public AnnotationVisitor visitAnnotation(String annoName, boolean isVisible) {
        String normalName = BundleClassVisitor.normalize(annoName);
        if (RunWith.class.getName().equals(normalName)) {
            return new RunWithAnnotationVisitor();
        }
        return null;
    }

    public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new TestMethodVisitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isSublassOf(String superName, String classToExtend) {
        InputStream is;
        boolean isSubclass;
        block6: {
            isSubclass = false;
            if (BundleClassVisitor.normalize(superName).equals("java.lang.Object")) {
                return isSubclass;
            }
            String path = superName.replace('.', '/');
            is = null;
            try {
                ClassReader classReader;
                URL superUrl = this.bundle.getEntry(path + ".class");
                if (null != superUrl) {
                    is = superUrl.openStream();
                }
                if (null == is || (isSubclass = BundleClassVisitor.normalize((classReader = new ClassReader(is)).getSuperName()).equals(classToExtend))) break block6;
                isSubclass = this.isSublassOf(classReader.getSuperName(), classToExtend);
            }
            catch (Exception e) {
                IOUtils.closeQuietly(is);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return isSubclass;
    }

    static String normalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        return name.replace('/', '.');
    }

    private class TestMethodVisitor
    extends EmptyVisitor {
        private TestMethodVisitor() {
        }

        public AnnotationVisitor visitAnnotation(String name, boolean visible) {
            if (Test.class.getName().equals(BundleClassVisitor.normalize(name))) {
                BundleClassVisitor.this.isTestClass = true;
            }
            return null;
        }
    }

    private class RunWithAnnotationVisitor
    extends EmptyVisitor {
        private RunWithAnnotationVisitor() {
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                Type type = (Type)value;
                if (AtlassianPluginsTestRunner.class.getName().equals(BundleClassVisitor.normalize(type.getInternalName()))) {
                    BundleClassVisitor.this.isWiredTest = true;
                }
            }
        }
    }
}

