/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.test;

import com.atlassian.plugins.osgi.test.asm.BundleTestScanner;
import com.atlassian.plugins.osgi.test.util.Pair;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.Bundle;

public class BundleTestClassesManager {
    private static BundleTestClassesManager INSTANCE;
    private ConcurrentHashMap<String, Set<Class<?>>> unitTestClasses = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<Class<?>>> itTestClasses = new ConcurrentHashMap();
    private CopyOnWriteArrayList<Bundle> bundles = new CopyOnWriteArrayList();

    private BundleTestClassesManager() {
    }

    public static BundleTestClassesManager instance() {
        if (null == INSTANCE) {
            INSTANCE = new BundleTestClassesManager();
        }
        return INSTANCE;
    }

    public void registerBundle(Bundle bundle) {
        if (bundle.getSymbolicName().endsWith("-tests")) {
            BundleTestScanner scanner = new BundleTestScanner();
            Pair<Set<Class<?>>, Set<Class<?>>> unitAndItTests = scanner.scan(bundle);
            if (!unitAndItTests.first().isEmpty()) {
                this.unitTestClasses.putIfAbsent(bundle.getSymbolicName(), unitAndItTests.first());
            }
            if (!unitAndItTests.second().isEmpty()) {
                this.itTestClasses.putIfAbsent(bundle.getSymbolicName(), unitAndItTests.second());
            }
            if (unitAndItTests.first().size() > 0 || unitAndItTests.second().size() > 0) {
                this.bundles.addIfAbsent(bundle);
            }
        }
    }

    public void unRegisterBundle(Bundle bundle) {
        if (bundle.getSymbolicName().endsWith("-tests")) {
            if (this.unitTestClasses.containsKey(bundle.getSymbolicName())) {
                this.unitTestClasses.remove(bundle.getSymbolicName());
            }
            if (this.itTestClasses.containsKey(bundle.getSymbolicName())) {
                this.itTestClasses.remove(bundle.getSymbolicName());
            }
            this.bundles.remove(bundle);
        }
    }

    public Set<Class<?>> getUnitTests(String bundleSymbolicName) {
        if (this.unitTestClasses.containsKey(bundleSymbolicName)) {
            return ImmutableSet.copyOf((Iterable)this.unitTestClasses.get(bundleSymbolicName));
        }
        return Collections.emptySet();
    }

    public Set<Class<?>> getIntegrationTests(String bundleSymbolicName) {
        if (this.itTestClasses.containsKey(bundleSymbolicName)) {
            return ImmutableSet.copyOf((Iterable)this.itTestClasses.get(bundleSymbolicName));
        }
        return Collections.emptySet();
    }

    public Class<?> findTestClassInBundle(String bundleSymbolicName, String classname) {
        Class<?> testClass = this.findTestClassInBundle(bundleSymbolicName, classname, this.unitTestClasses);
        if (null == testClass) {
            testClass = this.findTestClassInBundle(bundleSymbolicName, classname, this.itTestClasses);
        }
        return testClass;
    }

    public Pair<String, Class<?>> findTestClass(String classname) {
        Pair<String, Class<?>> testClass = this.findTestClass(classname, this.unitTestClasses);
        if (null == testClass) {
            testClass = this.findTestClass(classname, this.itTestClasses);
        }
        return testClass;
    }

    public boolean hasMoreThanOneBundle() {
        HashSet bundleKeys = new HashSet(this.unitTestClasses.keySet());
        bundleKeys.addAll(this.itTestClasses.keySet());
        return bundleKeys.size() > 1;
    }

    public boolean hasBundle(String bundleSymbolicName) {
        HashSet bundleKeys = new HashSet(this.unitTestClasses.keySet());
        bundleKeys.addAll(this.itTestClasses.keySet());
        return bundleKeys.contains(bundleSymbolicName);
    }

    public List<Bundle> getAllBundles() {
        return ImmutableList.copyOf(this.bundles);
    }

    public Set<String> getAllBundleKeys() {
        HashSet bundleKeys = new HashSet(this.unitTestClasses.keySet());
        bundleKeys.addAll(this.itTestClasses.keySet());
        return ImmutableSet.copyOf(bundleKeys);
    }

    private Class<?> findTestClassInBundle(String bundleSymbolicName, String classname, Map<String, Set<Class<?>>> classMap) {
        Class<?> testClass = null;
        Set<Class<?>> classes = classMap.get(bundleSymbolicName);
        if (null != classes) {
            for (Class<?> classToCheck : classes) {
                if (!classname.equals(classToCheck.getName())) continue;
                testClass = classToCheck;
                break;
            }
        }
        return testClass;
    }

    private Pair<String, Class<?>> findTestClass(final String classname, Map<String, Set<Class<?>>> classMap) {
        Class testClass = null;
        String bundleSymbolicName = null;
        for (Map.Entry<String, Set<Class<?>>> unitEntry : classMap.entrySet()) {
            bundleSymbolicName = unitEntry.getKey();
            try {
                testClass = (Class)Iterables.find((Iterable)unitEntry.getValue(), (Predicate)new Predicate<Class<?>>(){

                    public boolean apply(Class<?> input) {
                        return classname.equals(input.getName());
                    }
                });
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            if (null == testClass) continue;
            break;
        }
        if (null == testClass) {
            return null;
        }
        return Pair.pair(bundleSymbolicName, testClass);
    }
}

