package com.atlassian.plugins.osgi.javaconfig;

import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.reflect.FastClass;

/**
 * This class serves no purpose other than to make sure that plugins using this library end up with the necessary
 * packages in their <code>&lt;Import-Package&gt;</code> BND instruction.
 */
@SuppressWarnings("unused")
final class Imports {

    private Imports() {
        throw new UnsupportedOperationException("This class is not for instantiation");
    }

    /*
        These classes are required by this library, but BND does not add their packages to Import-Package by default, so
        we mention them here to ensure it does. This saves the plugin developer having to import these packages
        themselves. This list was assembled experimentally by seeing what NoClassDefFound errors were thrown when the
        consuming plugin was loaded.
     */
    private FastClass fastClass;
    private MethodProxy methodProxy;
    private ReflectUtils reflectUtils;
}
