package com.atlassian.plugins.osgi.javaconfig.conditions.product;

import com.atlassian.annotations.PublicApi;

/**
 * A Spring {@link org.springframework.context.annotation.Condition} that only returns <code>true</code> if the plugin
 * is running within Fisheye/Crucible.
 *
 * @since 0.1
 */
@PublicApi
public final class FecruOnly extends AbstractProductCondition {

    /**
     * Constructor invoked reflectively by Spring.
     */
    public FecruOnly() {
        super("com.atlassian.fisheye.spi.services.RepositoryService");
    }
}
