define('atlassian-nps-plugin/js/nps/product', [
    'atlassian-nps-plugin/js/amd-shims/ajs'
], function(
    AJS
) {
    'use strict';

    return {
        getProductName: function() {
            return 'Bitbucket';
        },

        setBindings: function() {
            return false; // No extra requirements for "idle" in Bitbucket Server
        },

        getUserKey: function() {
            return AJS.$(".user-dropdown #current-user").data('username');
        },

        isServerMode: function() {
            return true;
        },

        allowDisplayNotification: function() {
            // Don't allow to show if user is in onboarding flow
            return !this.isOnboardingFlow();
        },

        getSurveyTrigger: function() {
            return '.user-dropdown-trigger';
        },

        enableABTesting: function() {
            if (AJS.DarkFeatures && AJS.DarkFeatures.isEnabled("nps.experiment.enabled.by.sen") !== undefined) {
                return AJS.DarkFeatures.isEnabled("nps.experiment.enabled.by.sen");
            }
            return true;
        },

        allowDisplayAcknowledgementFlag: function() {
            // Don't allow to show if user is in onboarding flow
            return !this.isOnboardingFlow();
        },

        isOnboardingFlow: function() {
            var currentLocation = window.location;
            return /\/(getting-started|upgrade-onboarding)$/.test(currentLocation.href);
        }
    };
});
