/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.jira;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.webresource.condition.SimpleUrlReadingCondition;
import java.util.Map;

public class IsUserAdminUrlReadingCondition
extends SimpleUrlReadingCondition {
    private static final String IS_USER_ADMINISTRATOR = "is-system-admin";
    private GlobalPermissionManager permissionManager;
    private JiraAuthenticationContext authenticationContext;

    public IsUserAdminUrlReadingCondition(GlobalPermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    protected boolean isConditionTrue() {
        return this.permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.authenticationContext.getLoggedInUser());
    }

    protected String queryKey() {
        return IS_USER_ADMINISTRATOR;
    }
}

