/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin.confluence;

import com.atlassian.confluence.setup.settings.ConfluenceFlavourService;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.condition.UrlReadingCondition;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import java.util.Map;

public class IsServerInstanceUrlReadingCondition
implements UrlReadingCondition {
    private final ConfluenceFlavourService confluenceFlavourService;
    private static final String SERVER_TYPE = "VANILLA";
    private static final String QUERY_PARAM_NAME = "is-server-instance";

    public IsServerInstanceUrlReadingCondition(ConfluenceFlavourService confluenceFlavourService) {
        this.confluenceFlavourService = confluenceFlavourService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isServerInstance()) {
            urlBuilder.addToQueryString(QUERY_PARAM_NAME, String.valueOf(true));
        }
    }

    public boolean shouldDisplay(QueryParams params) {
        return Boolean.valueOf(params.get(QUERY_PARAM_NAME));
    }

    public boolean isServerInstance() {
        Option confluenceServerFlavour = this.confluenceFlavourService.tryParseConfluenceFlavour(SERVER_TYPE);
        return this.confluenceFlavourService.isCurrentFlavourEqualTo(confluenceServerFlavour);
    }
}

