define('atlassian-nps-plugin/js/nps/product', [
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'atlassian-nps-plugin/js/amd-shims/wrm'
], function(
    AJS,
    WRM
) {
    'use strict';

    var isServerMode;
    var username;

    return {
        getProductName: function() {
            return 'Bamboo';
        },

        setBindings: function() {
            /*
             * These binding are used to catch Javascript events that allow NPS framework to identify if users are idle or not.
             * If users are non-idle, the survey won't be shown.
             * It's not implemented by Bamboo by now. That implies users are considered non-idle all the time and the survey
             * can appear in any non-admin page.
             */
            return false;
        },

        getUserKey: function() {
            if (username === undefined) {
                username =  WRM.data.claim("com.atlassian.plugins.atlassian-nps-plugin:atlassian-nps-plugin-resources.logged-in-username-data-provider");
            }
            return username;
        },

        isServerMode: function() {
            if (isServerMode === undefined) {
                var dataProvider = WRM.data.claim("com.atlassian.plugins.atlassian-nps-plugin:atlassian-nps-plugin-resources.is-server-instance-data-provider");
                isServerMode = (dataProvider === true);
            }
            return isServerMode;
        },

        getSurveyTrigger: function() {
            return '#userInfo';
        },

        enableABTesting: function() {
            return !!(AJS.DarkFeatures && AJS.DarkFeatures.isEnabled("nps.experiment.enabled.by.sen"));
        },

        allowDisplayNotification: function() {
            return true;
        },

        allowDisplayAcknowledgementFlag: function() {
            return true;
        }
    };
});
