/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nps.plugin;

import com.atlassian.nps.plugin.NpsKey;
import com.atlassian.nps.plugin.storage.UserServerStorageService;
import com.atlassian.nps.plugin.utils.Clock;
import com.atlassian.nps.plugin.utils.RandomProvider;
import com.atlassian.nps.plugin.utils.UserHelper;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpsConfig {
    private static final Logger LOG = LoggerFactory.getLogger(NpsConfig.class);
    private final UserServerStorageService userServerStorageService;
    private final UserHelper userHelper;
    private final Clock clock;
    private final RandomProvider randomProvider;
    public static final long MILLISECONDS_IN_MINUTE = 60000L;
    public static final long MILLISECONDS_IN_DAY = 86400000L;
    public static final long MINIMUM_INITIAL_DAYS_UNTIL_SURVEY = 7L;
    public static final long MAXIMUM_INITIAL_DAYS_UNTIL_SURVEY = 14L;
    public static final long MINIMUM_DAYS_UNTIL_FOLLOWUP_SURVEY = 30L;
    public static final long MAXIMUM_DAYS_UNTIL_FOLLOWUP_SURVEY = 150L;

    public NpsConfig(UserServerStorageService userServerStorageService, UserHelper userHelper, Clock clock, RandomProvider randomProvider) {
        this.userServerStorageService = userServerStorageService;
        this.userHelper = userHelper;
        this.clock = clock;
        this.randomProvider = randomProvider;
    }

    public Map<String, Object> getAllConfig() {
        HashMap<String, Object> allConfig = new HashMap<String, Object>();
        allConfig.put(NpsKey.NEXT_SURVEY_DATE.getBasicKey(), this.getNextSurveyDate());
        allConfig.put(NpsKey.DISMISSED_COUNT.getBasicKey(), this.getDismissedCount());
        allConfig.put(NpsKey.OPTED_OUT.getBasicKey(), this.isOptedOut());
        allConfig.put("timeToNextSurvey", this.timeToNextSurvey());
        return allConfig;
    }

    public void deleteAllConfig() {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        this.userServerStorageService.deleteSetting(userKey, this.createKey(NpsKey.NEXT_SURVEY_DATE));
        this.userServerStorageService.deleteSetting(userKey, this.createKey(NpsKey.OPTED_OUT));
        this.userServerStorageService.deleteSetting(userKey, this.createKey(NpsKey.DISMISSED_COUNT));
    }

    public long timeToNextSurvey() {
        return this.getNextSurveyDate() - this.clock.getCurrentDate().getTime();
    }

    public long getNextSurveyDate() {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        String nextSurveyDate = this.userServerStorageService.getSetting(userKey, this.createKey(NpsKey.NEXT_SURVEY_DATE));
        if (StringUtils.isNotEmpty((String)nextSurveyDate)) {
            try {
                return Long.valueOf(nextSurveyDate);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Invalid format of next survey date was found in storage ({}). Calculating initial survey date as a fallback.", (Object)nextSurveyDate);
                return this.calculateInitialSurveyDate();
            }
        }
        long initialSurveyDate = this.calculateInitialSurveyDate();
        this.userServerStorageService.putSetting(userKey, this.createKey(NpsKey.NEXT_SURVEY_DATE), Long.toString(initialSurveyDate));
        return initialSurveyDate;
    }

    public void setNextSurveyDateForTest(Long date) {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        if (date != null) {
            this.userServerStorageService.putSetting(userKey, this.createKey(NpsKey.NEXT_SURVEY_DATE), date.toString());
        }
    }

    public boolean isOptedOut() {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        String optedOut = this.userServerStorageService.getSetting(userKey, this.createKey(NpsKey.OPTED_OUT));
        return StringUtils.isNotEmpty((String)optedOut) && Boolean.parseBoolean(optedOut);
    }

    public void setNextSurveyDate(Long date) {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        long currentServerSurveyDate = this.getNextSurveyDate();
        if (this.isValidSurveyDate(date)) {
            if (currentServerSurveyDate - date < 0L) {
                this.userServerStorageService.putSetting(userKey, this.createKey(NpsKey.NEXT_SURVEY_DATE), date.toString());
            }
        } else {
            this.generateAndSetSurveyDate();
        }
    }

    public void generateAndSetSurveyDate() {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        String nextSurveyDateString = this.calculateNextSurveyDate();
        this.userServerStorageService.putSetting(userKey, this.createKey(NpsKey.NEXT_SURVEY_DATE), nextSurveyDateString);
    }

    public void setOptedOut(Boolean optedOut) {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        if (optedOut != null && !this.isOptedOut()) {
            this.userServerStorageService.putSetting(userKey, this.createKey(NpsKey.OPTED_OUT), optedOut.toString());
        }
    }

    public void setOptedOutForTest(Boolean optedOut) {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        if (optedOut != null) {
            this.userServerStorageService.putSetting(userKey, this.createKey(NpsKey.OPTED_OUT), optedOut.toString());
        }
    }

    public void setDismissedCount(Integer dismissedCount) {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        if (dismissedCount != null) {
            this.userServerStorageService.putSetting(userKey, this.createKey(NpsKey.DISMISSED_COUNT), dismissedCount.toString());
        } else {
            LOG.debug("Not storing dismissed counter as dismissedCount is null");
        }
    }

    private Integer getDismissedCount() {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        String dismissedCount = this.userServerStorageService.getSetting(userKey, this.createKey(NpsKey.DISMISSED_COUNT));
        if (StringUtils.isNotEmpty((String)dismissedCount)) {
            return Integer.parseInt(dismissedCount);
        }
        return null;
    }

    private boolean isValidSurveyDate(Long date) {
        return date != null && this.clock.getCurrentDate().getTime() - date < 0L;
    }

    private String createKey(NpsKey baseKey) {
        UserKey userKey = this.userHelper.getUserKey();
        Preconditions.checkNotNull((Object)userKey);
        return baseKey.getKey() + "." + userKey.toString();
    }

    private long calculateInitialSurveyDate() {
        long now = this.clock.getCurrentDate().getTime();
        long randomInterval = this.getRandomTimeInterval(7L, 14L);
        return now + randomInterval;
    }

    private String calculateNextSurveyDate() {
        long now = this.clock.getCurrentDate().getTime();
        long surveyDate = now + this.getRandomTimeInterval(30L, 150L);
        return String.valueOf(surveyDate);
    }

    private long getRandomTimeInterval(long minDays, long maxDays) {
        Preconditions.checkArgument((minDays <= maxDays ? 1 : 0) != 0);
        long difference = maxDays - minDays;
        long randomInterval = (long)(this.randomProvider.getRandom() * (double)difference) + minDays;
        return this.daysToMilliseconds(randomInterval);
    }

    private long daysToMilliseconds(long days) {
        return days * 86400000L;
    }
}

