/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.capabilities.services;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.navlink.producer.capabilities.ApplicationWithCapabilities;
import com.atlassian.plugins.navlink.producer.capabilities.Capability;
import com.atlassian.plugins.navlink.producer.capabilities.plugin.CapabilityModuleDescriptor;
import com.atlassian.plugins.navlink.producer.capabilities.services.ApplicationTypeService;
import com.atlassian.plugins.navlink.producer.capabilities.services.CapabilityService;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCapabilityService
implements CapabilityService {
    private final Logger logger = LoggerFactory.getLogger(DefaultCapabilityService.class);
    private final PluginAccessor pluginAccessor;
    private final ApplicationTypeService applicationTypeService;
    private final ApplicationProperties applicationProperties;

    public DefaultCapabilityService(PluginAccessor pluginAccessor, ApplicationTypeService applicationTypeService, ApplicationProperties applicationProperties) {
        this.pluginAccessor = pluginAccessor;
        this.applicationTypeService = applicationTypeService;
        this.applicationProperties = applicationProperties;
    }

    @Override
    @Nonnull
    public ApplicationWithCapabilities getHostApplication() {
        String applicationType = this.applicationTypeService.get();
        List<Capability> capabilitiesFromPluginModules = this.getCapabilitiesFromPluginModules();
        Iterable usableCapabilities = Iterables.filter(capabilitiesFromPluginModules, this.byApplicationType(applicationType));
        Map<String, String> capabilities = this.asMap(usableCapabilities);
        return new ApplicationWithCapabilities(applicationType, new DateTime((Object)this.applicationProperties.getBuildDate()), capabilities);
    }

    @Nonnull
    private List<Capability> getCapabilitiesFromPluginModules() {
        List<CapabilityModuleDescriptor> enabledModuleDescriptors = this.getEnabledModuleDescriptors();
        return Lists.newArrayList((Iterable)Iterables.transform(enabledModuleDescriptors, this.toCapability()));
    }

    @Nonnull
    private List<CapabilityModuleDescriptor> getEnabledModuleDescriptors() {
        List<CapabilityModuleDescriptor> moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CapabilityModuleDescriptor.class);
        return moduleDescriptors != null ? moduleDescriptors : Collections.emptyList();
    }

    @Nonnull
    private Function<CapabilityModuleDescriptor, Capability> toCapability() {
        return new Function<CapabilityModuleDescriptor, Capability>(){

            @Nullable
            public Capability apply(@Nullable CapabilityModuleDescriptor input) {
                return input != null ? input.getModule() : null;
            }
        };
    }

    @Nonnull
    private Predicate<Capability> byApplicationType(final @Nonnull String applicationType) {
        return new Predicate<Capability>(){

            public boolean apply(@Nullable Capability input) {
                if (input != null) {
                    String type = input.getType();
                    return Strings.isNullOrEmpty((String)type) || applicationType.equals(type);
                }
                return false;
            }
        };
    }

    @Nonnull
    private Map<String, String> asMap(@Nonnull Iterable<Capability> usableCapabilities) {
        HashMap<String, String> capabilities = new HashMap<String, String>();
        for (Capability capability : usableCapabilities) {
            this.logger.debug("Capability: {} at URL {}", new Object[]{capability.getName(), capability.getUrl()});
            capabilities.put(capability.getName(), capability.getUrl());
        }
        return capabilities;
    }
}

