/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.custom_apps;

import com.atlassian.plugins.custom_apps.api.CustomApp;
import com.atlassian.plugins.custom_apps.api.CustomAppService;
import com.atlassian.plugins.navlink.consumer.menu.services.NavigationLinkComparator;
import com.atlassian.plugins.navlink.producer.capabilities.services.ApplicationTypeService;
import com.atlassian.plugins.navlink.producer.navigation.links.LinkSource;
import com.atlassian.plugins.navlink.producer.navigation.services.NavigationLinkRepository;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLinkBuilder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NavigationLinkRepositoryAdapter
implements NavigationLinkRepository {
    private static final String NAVIGATION_LINK_KEY = "custom-apps";
    private final CustomAppService customAppService;
    private final ApplicationTypeService applicationTypeService;

    public NavigationLinkRepositoryAdapter(@Nonnull CustomAppService customAppService, @Nonnull ApplicationTypeService applicationTypeService) {
        this.customAppService = (CustomAppService)Preconditions.checkNotNull((Object)customAppService);
        this.applicationTypeService = (ApplicationTypeService)Preconditions.checkNotNull((Object)applicationTypeService);
    }

    @Override
    @Nonnull
    public Iterable<RawNavigationLink> all() {
        return this.matching(null);
    }

    @Override
    @Nonnull
    public Iterable<RawNavigationLink> matching(@Nullable Predicate<RawNavigationLink> predicate) {
        List<CustomApp> customAppList = this.customAppService.getCustomApps();
        Iterable<RawNavigationLink> navigationLinks = this.transformCustomAppsToNavigationLinks(customAppList);
        Iterable<RawNavigationLink> filteredByPredicate = this.filterByPredicate(predicate, navigationLinks);
        Iterable<RawNavigationLink> result = this.filterNulls(filteredByPredicate);
        return Iterables.unmodifiableIterable(result);
    }

    @Nonnull
    private Iterable<RawNavigationLink> transformCustomAppsToNavigationLinks(@Nonnull Iterable<CustomApp> customAppList) {
        return Iterables.transform(customAppList, (Function)new Function<CustomApp, RawNavigationLink>(){

            public RawNavigationLink apply(@Nullable CustomApp customApp) {
                return customApp != null ? NavigationLinkRepositoryAdapter.this.createLocalNavigationLink(customApp) : null;
            }
        });
    }

    @Nonnull
    private Iterable<RawNavigationLink> filterByPredicate(@Nullable Predicate<RawNavigationLink> predicate, @Nonnull Iterable<RawNavigationLink> navigationLinks) {
        return predicate != null ? Iterables.filter(navigationLinks, predicate) : navigationLinks;
    }

    @Nonnull
    private Iterable<RawNavigationLink> filterNulls(@Nonnull Iterable<RawNavigationLink> filtered) {
        return Iterables.filter(filtered, (Predicate)Predicates.notNull());
    }

    @Nonnull
    private RawNavigationLink createLocalNavigationLink(@Nonnull CustomApp customApp) {
        return ((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)new RawNavigationLinkBuilder().key(NAVIGATION_LINK_KEY)).labelKey(customApp.getDisplayName()).href(customApp.getUrl())).source(LinkSource.localDefault())).applicationType(this.applicationTypeService.get())).weight(NavigationLinkComparator.Weights.MAX.value())).build();
    }
}

