/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.producer.capabilities;

import com.atlassian.plugins.capabilities.api.AppWithCapabilities;
import com.atlassian.plugins.navlink.producer.capabilities.CapabilityKey;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Immutable
public class ApplicationWithCapabilities
implements AppWithCapabilities {
    protected static final DateTime NULL_DATE = new DateTime(0L, DateTimeZone.UTC);
    protected final String id;
    protected final String name;
    protected final String type;
    protected final DateTime buildDate;
    protected final ImmutableMap<String, String> capabilities;

    public ApplicationWithCapabilities(@Nullable String type, @Nullable DateTime buildDate, Map<String, String> capabilities) {
        this.id = null;
        this.type = type;
        this.name = null;
        this.buildDate = this.toNonnull(buildDate);
        this.capabilities = ImmutableMap.copyOf(capabilities);
    }

    private DateTime toNonnull(DateTime buildDate) {
        return buildDate != null ? buildDate : NULL_DATE;
    }

    @Deprecated
    public String getId() {
        return this.id;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public DateTime getBuildDate() {
        return this.buildDate;
    }

    public boolean hasCapabilities() {
        return !this.capabilities.isEmpty();
    }

    public boolean hasCapability(CapabilityKey key) {
        return this.capabilities.containsKey((Object)key.getKey());
    }

    @Nullable
    public String getCapabilityUrl(CapabilityKey key) {
        return this.getCapabilityUrl(key.getKey());
    }

    @Nonnull
    public ImmutableMap<String, String> getCapabilities() {
        return this.capabilities;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.type, this.buildDate});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationWithCapabilities)) {
            return false;
        }
        ApplicationWithCapabilities that = (ApplicationWithCapabilities)obj;
        return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.buildDate, (Object)that.buildDate);
    }

    public String toString() {
        return "ApplicationWithCapabilities{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", buildDate='" + this.buildDate + '\'' + ", capabilities=" + this.capabilities + '}';
    }

    public boolean hasCapability(String key) {
        return this.capabilities.containsKey((Object)key);
    }

    @Nullable
    public String getCapabilityUrl(String key) {
        return (String)this.capabilities.get((Object)key);
    }
}

